/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.UserMappingsManager;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import java.util.Map;
import org.slf4j.Logger;

public class UsersMappingService {
    private final UserMappingsFileManager userMappingsFileManager;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private static final Logger log = ContextLoggerFactory.getLogger(UsersMappingService.class);

    public UsersMappingService(UserMappingsFileManager userMappingsFileManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager, EnterpriseGatekeeperClient enterpriseGatekeeperClient) {
        this.userMappingsFileManager = userMappingsFileManager;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
    }

    public void saveUserMappingsToFile(String cloudId, String planId, String migrationScopeId) {
        try {
            if (!this.userMappingsFileManager.isMappingFilePresent(planId)) {
                UserMappingsManager userMappingsManager = new UserMappingsManager(this.migrationDarkFeaturesManager, this.enterpriseGatekeeperClient, cloudId, migrationScopeId);
                Map<String, String> mappings = userMappingsManager.getMappings();
                this.userMappingsFileManager.saveToFile(planId, mappings);
            }
        }
        catch (RuntimeException e) {
            log.error("Error getUserMappingsAndSaveToFile: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

