/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.event.PlanCompletionEvent;
import com.atlassian.migration.agent.service.planning.TaskPlanningEngine;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.InProgressMigration;
import com.atlassian.migration.agent.v4.InProgressMigrationIds;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.pollers.AbstractPoller;
import com.atlassian.migration.agent.v4.pollers.status.InProgressMigrationStatus;
import com.atlassian.migration.agent.v4.pollers.status.StatusRetreivalService;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPoller
extends AbstractPoller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusPoller.class);
    private InProgressMigrationIds inProgressMigrationIds;
    private PlanStore planStore;
    private TaskStore taskStore;
    private PluginTransactionTemplate ptx;
    private StatusRetreivalService statusRetreivalService;
    private final EventPublisher eventPublisher;
    private final TaskPlanningEngine taskPlanningEngine;
    private final ProgressTracker progressTracker;

    public StatusPoller(String pollerId, Duration pollingDelay, InProgressMigrationIds inProgressMigrationIds, PluginTransactionTemplate ptx, PlanStore planStore, TaskStore taskStore, StatusRetreivalService statusRetreivalService, EventPublisher eventPublisher, TaskPlanningEngine taskPlanningEngine, ProgressTracker progressTracker) {
        super(pollerId, pollingDelay);
        this.inProgressMigrationIds = inProgressMigrationIds;
        this.ptx = ptx;
        this.planStore = planStore;
        this.taskStore = taskStore;
        this.statusRetreivalService = statusRetreivalService;
        this.eventPublisher = eventPublisher;
        this.taskPlanningEngine = taskPlanningEngine;
        this.progressTracker = progressTracker;
    }

    @Override
    protected boolean doPoll() {
        return this.inProgressMigrationIds.sequence().filter(inProgressMigration -> inProgressMigration.getProtocol() == MigrationProtocol.V4).map(inProgressMigration -> {
            try {
                return this.pollStatusAndProcess((InProgressMigration)inProgressMigration);
            }
            catch (Throwable e) {
                log.error("Failed to poll & update status of migrationId: {}", (Object)inProgressMigration.getMigrationId(), (Object)e);
                return false;
            }
        }).anyMatch(isSuccess -> isSuccess);
    }

    private boolean pollStatusAndProcess(InProgressMigration inProgressMigration) {
        InProgressMigrationStatus inProgressMigrationStatus = this.statusRetreivalService.getAdaptedMigrationStatus(inProgressMigration);
        this.ptx.write(() -> {
            Plan plan = this.planStore.getPlan(inProgressMigration.getPlanId());
            Progress planProgress = plan.getProgress();
            if (planProgress.getStatus().isCompleted()) {
                log.debug("Plan is completed, progress will not be updated further");
                return;
            }
            if (inProgressMigrationStatus.isRetreivalSuccessful()) {
                if (inProgressMigrationStatus.isTasksUpdated()) {
                    planProgress = planProgress.copy().progress(this.taskStore.calculatePlanPercent(inProgressMigration.getPlanId()));
                }
                if (inProgressMigrationStatus.isStatusUnchanged()) {
                    planProgress = this.setDetailedStatusBasedOnTaskStatus(inProgressMigration.getPlanId(), plan, planProgress);
                    plan.setLastUpdate(Instant.now());
                } else {
                    planProgress = this.setProgressBasedOnStatus(inProgressMigration.getPlanId(), planProgress, inProgressMigrationStatus);
                }
                plan.setProgress(planProgress);
                this.planStore.updatePlan(plan);
                if (planProgress.getStatus().isCompleted()) {
                    this.progressTracker.savePlanAnalyticsEvents(plan.getId(), planProgress.getStatus() == ExecutionStatus.DONE);
                    this.eventPublisher.publish((Object)new PlanCompletionEvent(this, plan.getId()));
                }
            }
        });
        return inProgressMigrationStatus.isRetreivalSuccessful();
    }

    private Progress setDetailedStatusBasedOnTaskStatus(String planId, Plan plan, Progress planProgress) {
        Optional<Task> successTask = this.taskStore.findLastTaskWithStatusForPlan(planId, ExecutionStatus.DONE);
        List<Task> nextTasks = successTask.isPresent() && !planProgress.getDetailedStatus().equals("Started") ? this.taskPlanningEngine.getNextTasks(successTask.get()) : this.taskPlanningEngine.getFirstTasks(planId);
        this.progressTracker.updateDetailedStatusForPlan(nextTasks);
        return plan.getProgress().copy().progress(planProgress.getPercent());
    }

    private Progress setProgressBasedOnStatus(String planId, Progress planProgress, InProgressMigrationStatus inProgressMigrationStatus) {
        Progress newProgress = planProgress;
        if (inProgressMigrationStatus.getCurrentStatus().isCompleted()) {
            newProgress = this.updateProgressToComplete(planId, planProgress);
        } else {
            switch (inProgressMigrationStatus.getCurrentStatus()) {
                case STOPPING: {
                    newProgress = planProgress.copy().stopping();
                    break;
                }
                case RUNNING: {
                    newProgress = planProgress.copy().started();
                    break;
                }
                default: {
                    log.warn("Unknown status: {}", (Object)inProgressMigrationStatus.getCurrentStatus());
                }
            }
        }
        return newProgress;
    }

    private Progress updateProgressToComplete(String planId, Progress planProgress) {
        Progress newProgress;
        Optional<Task> failedTask = this.taskStore.findFirstTaskWithStatusForPlan(planId, ExecutionStatus.FAILED);
        Optional<Task> stoppedTask = this.taskStore.findFirstTaskWithStatusForPlan(planId, ExecutionStatus.STOPPED);
        boolean hasSuccessfulSpaceTask = this.taskStore.existTaskByStatusByTypeInPlan(planId, ExecutionStatus.DONE, Arrays.asList(ConfluenceSpaceTask.class));
        if (stoppedTask.isPresent()) {
            newProgress = planProgress.copy().stopped();
        } else if (failedTask.isPresent() && !hasSuccessfulSpaceTask) {
            String message = failedTask.get().getProgress().getMessage();
            newProgress = planProgress.copy().failed(message);
        } else {
            newProgress = planProgress.getStatus() == ExecutionStatus.STOPPED ? planProgress.copy().stopped() : failedTask.map(task -> planProgress.copy().incomplete(task.getProgress().getMessage())).orElseGet(() -> planProgress.copy().done());
        }
        return newProgress;
    }
}

