/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.correctedemails;

import com.atlassian.migration.agent.store.CorrectedEmailStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.udc.utils.UDCMapperUtils;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.correctedemails.CorrectedEmail;
import com.atlassian.migration.udc.common.model.repository.DbResult;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.correctedemails.CorrectedEmailRepository;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCMACorrectedEmailsRepository
implements CorrectedEmailRepository {
    private final CorrectedEmailStore correctedEmailStore;
    private final PluginTransactionTemplate ptx;

    public long changeDraftDataToConfirmed(@NotNull UDCMode udcMode) {
        return this.ptx.write(() -> {
            this.correctedEmailStore.deleteByDraftMode(udcMode, false);
            return this.correctedEmailStore.setDraftDataToConfirmed(udcMode);
        });
    }

    public long countByCheckType(@NotNull EmailCheckType emailCheckType, @NotNull UDCMode udcMode, boolean draft) {
        return this.ptx.read(() -> this.correctedEmailStore.countByCheckType(emailCheckType, udcMode, draft));
    }

    public long deleteByEmailCheckType(@NotNull EmailCheckType emailCheckType, @NotNull UDCMode udcMode) {
        return this.ptx.write(() -> this.correctedEmailStore.deleteByEmailCheckType(emailCheckType, udcMode));
    }

    public long deleteByUdcMode(@NotNull UDCMode udcMode) {
        return this.ptx.write(() -> this.correctedEmailStore.deleteByUdcMode(udcMode));
    }

    public long deleteDraft(@NotNull UDCMode udcMode) {
        return this.ptx.write(() -> this.correctedEmailStore.deleteByDraftMode(udcMode, true));
    }

    @NotNull
    public List<CorrectedEmail> fetchAll(@NotNull UDCMode udcMode, boolean draft) {
        return this.ptx.read(() -> this.correctedEmailStore.fetchAll(udcMode, draft).stream().map(UDCMapperUtils::toCorrectedEmail).collect(Collectors.toList()));
    }

    @NotNull
    public List<CorrectedEmail> fetchByEmailCheckType(@Nullable EmailCheckType emailCheckType, @NotNull UDCMode udcMode, boolean draft) {
        return this.ptx.read(() -> this.correctedEmailStore.fetchByEmailCheckType(emailCheckType == null ? null : emailCheckType, udcMode, draft).stream().map(UDCMapperUtils::toCorrectedEmail).collect(Collectors.toList()));
    }

    @NotNull
    public List<String> findUserKeysByType(@NotNull EmailCheckType emailCheckType, @NotNull UDCMode udcMode, boolean draft) {
        return this.ptx.read(() -> this.correctedEmailStore.findUserKeysByType(emailCheckType, udcMode, draft));
    }

    @NotNull
    public DbResult insert(@NotNull Sequence<CorrectedEmail> sequence, @NotNull String userKey) {
        return this.ptx.write(() -> this.correctedEmailStore.insert(SequencesKt.toList((Sequence)sequence).stream().map(UDCMapperUtils::toCorrectedEmail).collect(Collectors.toList()), userKey));
    }

    public boolean isAnyRecordFound(@NotNull UDCMode udcMode, boolean draft) {
        return this.ptx.read(() -> this.correctedEmailStore.isAnyRecordFound(udcMode, draft));
    }

    public boolean isRecordFoundForEmailCheckType(@NotNull EmailCheckType emailCheckType, @NotNull UDCMode udcMode, boolean draft) {
        return this.ptx.read(() -> this.correctedEmailStore.isRecordFoundForEmailCheckType(emailCheckType, udcMode, draft));
    }

    @Generated
    public CCMACorrectedEmailsRepository(CorrectedEmailStore correctedEmailStore, PluginTransactionTemplate ptx) {
        this.correctedEmailStore = correctedEmailStore;
        this.ptx = ptx;
    }
}

