/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.migration.agent.entity.CloudEdition;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.model.ProductEditionDetails;
import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.migration.agent.service.featureflag.Fx3ClientFactory;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fx3Helper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Fx3Helper.class);
    private final Fx3ClientFactory fx3ClientFactory;
    private final FeatureFlagClient featureFlagClient;
    private final MigrationPlatformService migrationService;
    private static final String MIGRATION_TYPE = "MigrationType";
    private static final String SPACE_COUNT = "SpaceCount";
    private static final String CLOUD_ID = "CloudId";
    private static final String REGION = "Region";
    private static final String CLOUD_TYPE = "CloudType";
    private static final String EDITION = "Edition";
    private static final List<String> CONFLUENCE_PRODUCTS = Collections.singletonList("Confluence");
    private static final String DEFAULT_CLOUD_EDITION = "free";
    private static final String PRODUCT_EDITION = "ProductEdition";

    @Inject
    public Fx3Helper(Fx3ClientFactory fx3ClientFactory, FeatureFlagClient featureFlagClient, MigrationPlatformService migrationService) {
        this.fx3ClientFactory = fx3ClientFactory;
        this.featureFlagClient = featureFlagClient;
        this.migrationService = migrationService;
    }

    public void updateUserCustomAttributes(Plan plan) {
        Map<String, Object> fx3UserCustomAttributesMap = this.fx3ClientFactory.createCustomAttributesMap();
        this.populatePlanCustomAttributes(fx3UserCustomAttributesMap, plan);
        this.featureFlagClient.updateCustomAttributes(fx3UserCustomAttributesMap);
    }

    private void populatePlanCustomAttributes(Map<String, Object> fx3UserCustomAttributesMap, Plan plan) {
        Optional<CloudEdition> cloudEdition = Optional.ofNullable(plan.getCloudSite().getEdition());
        fx3UserCustomAttributesMap.put(MIGRATION_TYPE, this.evaluateMigrationType(plan));
        fx3UserCustomAttributesMap.put(SPACE_COUNT, this.getSpacesCount(plan));
        fx3UserCustomAttributesMap.put(CLOUD_ID, plan.getCloudSite().getCloudId());
        fx3UserCustomAttributesMap.put(REGION, this.migrationService.getConfluenceShardDetails(plan.getCloudSite().getContainerToken()).getShardInfo().get("region"));
        fx3UserCustomAttributesMap.put(CLOUD_TYPE, (Object)plan.getCloudSite().getCloudType());
        fx3UserCustomAttributesMap.put(EDITION, cloudEdition.map(Enum::name).orElse("NOT PRESENT"));
        fx3UserCustomAttributesMap.put(PRODUCT_EDITION, this.fetchProductEditionDetails(plan.getCloudSite()));
    }

    private Integer getSpacesCount(Plan plan) {
        return plan.getTasks().stream().filter(task -> task.getType().equals((Object)TaskType.SPACE) || task.getType().equals((Object)TaskType.ATTACHMENTS)).collect(Collectors.toSet()).size();
    }

    private String evaluateMigrationType(Plan plan) {
        List<Task> tasks = plan.getTasks();
        if (this.isSpaceAttachmentsOnlyTasks(tasks)) {
            return TaskType.ATTACHMENTS.name();
        }
        if (this.isUsersAndGroupsOnlyTasks(tasks)) {
            return TaskType.USERS.name();
        }
        if (this.isGlobalEntitiesOnlyTasks(tasks)) {
            return TaskType.GLOBAL_ENTITIES.name();
        }
        if (this.isAppsOnlyTasks(tasks)) {
            return TaskType.APPS.name();
        }
        return TaskType.SPACE.name();
    }

    private String fetchProductEditionDetails(CloudSite cloudSite) {
        try {
            Set productEditionList = this.migrationService.fetchProductEditionDetails(cloudSite.getContainerToken()).getData().getEssotEntitlement().stream().filter(entitlement -> CONFLUENCE_PRODUCTS.stream().anyMatch(product -> {
                String productName = entitlement.getProductCatalogItem().getName();
                return productName != null && Pattern.compile(product).matcher(productName).find();
            })).map(ProductEditionDetails.Entitlement::getEdition).filter(Objects::nonNull).collect(Collectors.toSet());
            String productEditionListString = productEditionList.toString();
            log.info("Fetched Product edition details from Hydra {}", (Object)productEditionListString);
            return productEditionListString;
        }
        catch (Exception e) {
            log.error("Error Occurred while fetching product edition details from Hydra", (Throwable)e);
            return DEFAULT_CLOUD_EDITION;
        }
    }

    private boolean isSpaceAttachmentsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.ATTACHMENTS));
    }

    private boolean isUsersAndGroupsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.USERS));
    }

    private boolean isGlobalEntitiesOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.GLOBAL_ENTITIES));
    }

    private boolean isAppsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.APPS));
    }
}

