/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers.status.converter;

import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceSpaceContainer;
import com.atlassian.migration.agent.service.catalogue.model.SiteContainer;
import com.atlassian.migration.agent.v4.pollers.status.converter.ContainerProgressConverter;
import com.atlassian.migration.agent.v4.pollers.status.converter.OperationKey;
import com.atlassian.migration.agent.v4.pollers.status.converter.TransferProgressConverter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ContainerProgressConverterFactory {
    private static final Map<OperationKey, TransferProgressConverter<ConfluenceSpaceContainer>> CONFLUENCE_ORDERED_TRANSFER_CONVERTER_MAP = ImmutableMap.of((Object)((Object)OperationKey.confluenceSpaceUserExport), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 10, "User migration started", "Migrated Users successfully"), (Object)((Object)OperationKey.confluenceAttachmentUpload), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> ContainerProgressConverterFactory.isAttachmentUploadOnly(confluenceSpaceContainer) ? 100 : 30, "Attachment upload started", "Attachments uploaded successfully"), (Object)((Object)OperationKey.confluenceSpaceExport), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 60, "Data export started", "Data exported successfully"), (Object)((Object)OperationKey.confluenceSpaceUpload), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 80, "Data export started", "Data uploaded successfully"), (Object)((Object)OperationKey.confluenceImport), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 100, "Data import started", "Data imported successfully"));
    private static final ContainerProgressConverter<ConfluenceSpaceContainer> CONFLUENCE_SPACE_PROGRESS_CONVERTER = new ContainerProgressConverter(CONFLUENCE_ORDERED_TRANSFER_CONVERTER_MAP);
    private static final Map<OperationKey, TransferProgressConverter<SiteContainer>> USER_AND_GROUP_ORDERED_TRANSFER_CONVERTER_MAP = ImmutableMap.of((Object)((Object)OperationKey.allUserUpload), new TransferProgressConverter<SiteContainer>(siteContainer -> 50, "Users and groups export started", "Users and groups uploaded successfully"), (Object)((Object)OperationKey.allUserImport), new TransferProgressConverter<SiteContainer>(siteContainer -> 100, "Users and groups import started", "Users and groups imported successfully"));
    private static final ContainerProgressConverter<SiteContainer> USER_AND_GROUP_PROGRESS_CONVERTER = new ContainerProgressConverter(USER_AND_GROUP_ORDERED_TRANSFER_CONVERTER_MAP);
    private static final Map<AbstractContainer.ContainerType, ContainerProgressConverter<? extends AbstractContainer>> CONTAINER_PROGRESS_CONVERTOR_MAP = ImmutableMap.of((Object)((Object)AbstractContainer.ContainerType.ConfluenceSpace), CONFLUENCE_SPACE_PROGRESS_CONVERTER);

    public static ContainerProgressConverter<?> getContainerProgressConvertor(AbstractContainer.ContainerType type) {
        ContainerProgressConverter<AbstractContainer> result;
        switch (type) {
            case ConfluenceSpace: {
                result = CONFLUENCE_SPACE_PROGRESS_CONVERTER;
                break;
            }
            case Site: {
                result = USER_AND_GROUP_PROGRESS_CONVERTER;
                break;
            }
            default: {
                throw new RuntimeException("No progress convertor defined for container type: ");
            }
        }
        return result;
    }

    private static boolean isAttachmentUploadOnly(ConfluenceSpaceContainer container) {
        return container.getSelections().size() == 1 && container.getSelections().contains((Object)ConfluenceSpaceContainer.SpaceSelection.ATTACHMENTS);
    }
}

