/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.fx3.Fx3Client;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.url.MigrationEnvironment;
import com.atlassian.migration.agent.service.featureflag.Fx3ClientFactory;
import com.atlassian.migration.agent.service.featureflag.StatsigFeatureGateNameMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlagClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeatureFlagClient.class);
    private final Fx3Client fx3Client;
    private final Fx3Client fx3ClientFedramp;
    private final StatsigFeatureGateNameMapper statsigFeatureGateNameMapper;
    private Fx3Client fx3ActiveClient;

    public FeatureFlagClient(Fx3ClientFactory fx3ClientFactory, StatsigFeatureGateNameMapper statsigFeatureGateNameMapper) {
        this.fx3Client = fx3ClientFactory.createFx3Client(MigrationEnvironment.DEFAULT);
        this.fx3ClientFedramp = fx3ClientFactory.createFx3Client(MigrationEnvironment.FEDRAMP);
        this.statsigFeatureGateNameMapper = statsigFeatureGateNameMapper;
    }

    public void updateCloudId(String cloudId) {
        try {
            this.getFx3ActiveClient().updateUserIdentifier(cloudId);
            this.getFx3ActiveClient().performManualFetch();
        }
        catch (Exception e) {
            log.error("Error occurred while updating cloud id", (Throwable)e);
        }
    }

    public void updateCustomAttributes(Map<String, Object> customAttributes) {
        try {
            this.getFx3ActiveClient().updateUserCustomAttributes(customAttributes);
        }
        catch (Exception e) {
            log.error("Error occurred while updating custom attributes", (Throwable)e);
        }
    }

    public boolean isFeatureEnabled(MigrationDarkFeaturesManager.FeatureFlags featureFlag) {
        return this.isFeatureEnabled(featureFlag, false);
    }

    public boolean isFeatureEnabled(MigrationDarkFeaturesManager.FeatureFlags flagKey, boolean defaultValue) {
        try {
            return this.isGateEnabledInStatsig(flagKey.getFlagName()) || this.getFx3ActiveClient().getAllEnabledFlagsForUser().contains(flagKey.getFlagName());
        }
        catch (Exception e) {
            log.error("Error occurred while checking feature flag", (Throwable)e);
            return defaultValue;
        }
    }

    public List<String> getAllEnabledFeatureFlags() {
        try {
            Set ldFlags = this.getFx3ActiveClient().getAllEnabledFlagsForUser();
            Set statsigFlags = this.getFx3ActiveClient().getAllEnabledGatesForUserFromStatsig().stream().map(this.statsigFeatureGateNameMapper::getDarkFeatureFlagName).filter(Objects::nonNull).collect(Collectors.toSet());
            HashSet result = new HashSet();
            result.addAll(ldFlags);
            result.addAll(statsigFlags);
            return new ArrayList<String>(result);
        }
        catch (Exception e) {
            log.error("Error occurred while getting all enabled feature flags", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private boolean isGateEnabledInStatsig(String flagKey) {
        return Boolean.TRUE.equals(this.getFx3ActiveClient().getGateFromStatsig(flagKey).getValue());
    }

    @Generated
    public Fx3Client getFx3Client() {
        return this.fx3Client;
    }

    @Generated
    public Fx3Client getFx3ClientFedramp() {
        return this.fx3ClientFedramp;
    }

    @Generated
    public StatsigFeatureGateNameMapper getStatsigFeatureGateNameMapper() {
        return this.statsigFeatureGateNameMapper;
    }

    @Generated
    public Fx3Client getFx3ActiveClient() {
        return this.fx3ActiveClient;
    }

    @Generated
    public void setFx3ActiveClient(Fx3Client fx3ActiveClient) {
        this.fx3ActiveClient = fx3ActiveClient;
    }
}

