/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.dto;

import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.migration.agent.dto.AppsProgressDto;
import com.atlassian.migration.agent.dto.CloudSiteDto;
import com.atlassian.migration.agent.dto.MigrationDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.PreflightCheckProgressDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.TaskDto;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.entity.PlanActiveStatus;
import com.atlassian.migration.json.InstantDeserializerCodehaus;
import com.atlassian.migration.json.InstantDeserializerFasterXml;
import com.atlassian.migration.json.InstantSerializerCodehaus;
import com.atlassian.migration.json.InstantSerializerFasterXml;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class PreflightCheckPlanDto {
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final String id;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final String checkExecutionId;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final String name;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    @JsonSerialize(using=InstantSerializerCodehaus.class)
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(using=InstantSerializerFasterXml.class)
    @JsonDeserialize(using=InstantDeserializerCodehaus.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=InstantDeserializerFasterXml.class)
    public final Instant lastUpdate;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final CloudSiteDto cloudSite;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final List<TaskDto> tasks;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final PreflightCheckProgressDto progress;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final List<String> preflightChecksToOverride;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final AppsProgressDto appsProgress;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final PlanActiveStatus activeStatus;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final MigrationDto migrationStatus;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    public final MigrationTag migrationTag;
    @org.codehaus.jackson.annotate.JsonProperty
    public final String migrationId;

    public PreflightCheckPlanDto(PlanDto planDto, List<CheckResultDto> checks, AppsProgressDto appsProgress, MigrationDto migrationStatus) {
        this.id = planDto.getId();
        this.checkExecutionId = planDto.getCheckExecutionId();
        this.name = planDto.getName();
        this.lastUpdate = planDto.getLastUpdate();
        this.cloudSite = planDto.getCloudSite();
        this.tasks = planDto.getTasks();
        this.progress = PreflightCheckPlanDto.populateProgress(planDto.getProgress(), checks, migrationStatus);
        this.preflightChecksToOverride = planDto.getPreflightChecksToOverride() != null ? planDto.getPreflightChecksToOverride() : Collections.emptyList();
        this.appsProgress = appsProgress;
        this.activeStatus = planDto.getActiveStatus();
        this.migrationStatus = migrationStatus;
        this.migrationTag = planDto.getMigrationTag();
        this.migrationId = planDto.getMigrationId();
    }

    private static PreflightCheckProgressDto populateProgress(ProgressDto progressDto, List<CheckResultDto> checks, MigrationDto migrationStatus) {
        return new PreflightCheckProgressDto(progressDto, checks, migrationStatus);
    }
}

