/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.migration.agent.service.featureflag.Fx3Helper;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationDarkFeaturesManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationDarkFeaturesManager.class);
    public static final String PLUGIN_FLAG_PREFIX = "migration-assistant";
    public static final String STATSIG_PLUGIN_FLAG_PREFIX = "migration-assistant-";
    public static final String LD_PLUGIN_FLAG_PREFIX = "migration-assistant.";
    private boolean spaceUsersMigrationEnabled;
    private final DarkFeatureManager darkFeatureManager;
    private final FeatureFlagClient featureFlagClient;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final Fx3Helper fx3Helper;

    public MigrationDarkFeaturesManager(DarkFeatureManager darkFeatureManager, FeatureFlagClient featureFlagClient, MigrationAgentConfiguration migrationAgentConfiguration, Fx3Helper fx3Helper) {
        this.darkFeatureManager = darkFeatureManager;
        this.featureFlagClient = featureFlagClient;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.fx3Helper = fx3Helper;
    }

    private boolean isFeatureEnabled(FeatureFlags featureFlags) {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(featureFlags.getFlagName());
    }

    public Set<String> getAllEnabledFeatures() {
        HashSet<String> enabledOnFeatureFlagService = new HashSet<String>(this.featureFlagClient.getAllEnabledFeatureFlags());
        EnabledDarkFeatures featuresEnabledForAllUsers = this.darkFeatureManager.getFeaturesEnabledForAllUsers();
        Set<Object> enabledOnServer = new HashSet();
        try {
            Method getFeatureKeySetMethod = featuresEnabledForAllUsers.getClass().getMethod("getFeatureKeySet", new Class[0]);
            Set featureKeySet = (Set)getFeatureKeySetMethod.invoke((Object)featuresEnabledForAllUsers, new Object[0]);
            enabledOnServer = featureKeySet.stream().filter(featureKey -> featureKey.startsWith(PLUGIN_FLAG_PREFIX)).collect(Collectors.toSet());
        }
        catch (NoSuchMethodException e) {
            try {
                Method getFeatureKeysMethod = featuresEnabledForAllUsers.getClass().getMethod("getFeatureKeys", new Class[0]);
                Set featureKeySet = (Set)getFeatureKeysMethod.invoke((Object)featuresEnabledForAllUsers, new Object[0]);
                enabledOnServer = featureKeySet.stream().filter(featureKey -> featureKey.startsWith(PLUGIN_FLAG_PREFIX)).collect(Collectors.toSet());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException innerException) {
                log.error("Error getting enabled features from confluenceServer", (Throwable)innerException);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Error getting enabled features from confluenceServer", (Throwable)e);
        }
        HashSet<String> result = new HashSet<String>();
        result.addAll(enabledOnFeatureFlagService);
        result.addAll(enabledOnServer);
        if (this.spaceUsersMigrationEnabled) {
            result.add(FeatureFlags.ENABLE_SPACE_USERS_MIGRATIONS_STEP.getFlagName());
        } else {
            result.remove(FeatureFlags.ENABLE_SPACE_USERS_MIGRATIONS_STEP.getFlagName());
        }
        return result;
    }

    public boolean appMigrationDevMode() {
        return this.isFeatureEnabled(FeatureFlags.APP_MIGRATION_DEV_MODE);
    }

    public boolean isBrowserMetricsEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_BROWSER_METRICS);
    }

    public boolean isQuickAssessmentEnabled() {
        return this.isFeatureEnabled(FeatureFlags.QUICK_ASSESSMENT);
    }

    public boolean missingAttachmentsCheckDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_MISSING_ATTACHMENTS_CHECK);
    }

    public boolean appOutdatedCheckDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_APP_OUTDATED_CHECK);
    }

    public boolean skipAttachmentUploadEnabled() {
        return this.isFeatureEnabled(FeatureFlags.SKIP_ATTACHMENTS_UPLOAD);
    }

    public boolean shouldHandleInvalidAndDuplicateEmailUsers() {
        return this.isFeatureEnabled(FeatureFlags.HANDLE_INVALID_DUPLICATE_EMAIL_USERS);
    }

    public boolean isV4MigrationProtocolEnabled() {
        if (Objects.equals(this.migrationAgentConfiguration.getMigrationExecutionEnvironment(), "ci")) {
            return this.isFeatureEnabled(FeatureFlags.ENABLE_V4_MIGRATION_PROTOCOL);
        }
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_V4_MIGRATION_PROTOCOL);
    }

    public boolean shouldHandleGlobalEmailFixes() {
        return this.isGlobalEmailFixesFeatureEnabled();
    }

    boolean isGlobalEmailFixesFeatureEnabled() {
        return !this.isFeatureEnabled(FeatureFlags.MIGRATION_ASSISTANT_DISABLE_GLOBAL_EMAIL_FIXES_FEATURE);
    }

    public boolean isGlobalEmailFixesNewEmailsFromDbEnabled() {
        return this.isFeatureEnabled(FeatureFlags.MIGRATION_ASSISTANT_ENABLE_NEW_EMAILS_FROM_DB);
    }

    public boolean isUmsCheckForTrustedDomainsDisabled() {
        return this.isFeatureEnabled(FeatureFlags.MIGRATION_ASSISTANT_DISABLE_UMS_CHECK_FOR_TRUSTED_DOMAINS);
    }

    public boolean isExtendedUmsTimeoutEnabled() {
        return this.isFeatureEnabled(FeatureFlags.MIGRATION_ASSISTANT_ENABLE_EXTENDED_UMS_TIMEOUT);
    }

    public boolean isExportOnlyEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_EXPORT_ONLY);
    }

    public boolean isTasklistFeatureDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_TASK_LIST_FEATURE);
    }

    public boolean appVendorCheckDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_APP_VENDOR_CHECK);
    }

    public boolean appVendorChecksFilterEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_APP_VENDOR_CHECK_FILTER);
    }

    public boolean isUploadOnlyEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_UPLOAD_ONLY);
    }

    public boolean isPreflightChecksDisabledBeforeRun() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_CHECKS_BEFORE_RUN);
    }

    public boolean isSpaceUsersMigrationStepEnabled() {
        return this.spaceUsersMigrationEnabled;
    }

    public boolean isLicenceCheckDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_LICENCE_CHECK);
    }

    public boolean isNewSpaceSelectorEnabled() {
        return !this.isFeatureEnabled(FeatureFlags.DISABLE_NEW_SPACE_SELECTOR);
    }

    public void refreshFeatureFlags() {
        this.spaceUsersMigrationEnabled = this.isFeatureEnabled(FeatureFlags.ENABLE_SPACE_USERS_MIGRATIONS_STEP) || this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_SPACE_USERS_MIGRATIONS_STEP);
    }

    public boolean fedRAMPEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_FED_RAMP);
    }

    public boolean isForceResetFlagEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_FORCE_RESET_FLAG);
    }

    public boolean isTokenEncryptionEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_TOKEN_ENCRYPTION);
    }

    public boolean isTeamCalendarsMigrationDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_TEAM_CALENDARS_MIGRATION) || this.featureFlagClient.isFeatureEnabled(FeatureFlags.DISABLE_TEAM_CALENDARS_MIGRATION);
    }

    public boolean isRelationsAnalysisEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_RELATIONS_ANALYSIS);
    }

    public boolean isRelationsAnalysisDuringInstanceAssessmentEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_RELATIONS_ANALYSIS_DURING_INSTANCE_ASSESSMENT);
    }

    public boolean isRelationsAnalysisUserGroupKeysDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS);
    }

    public boolean isRelationsAnalysisUserGroupKeysHashingDisabled() {
        return this.isFeatureEnabled(FeatureFlags.DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS_HASHING);
    }

    public boolean isParallelAppDataUploadsEnabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_PARALLEL_APP_DATA_UPLOADS);
    }

    public boolean isSpaceAliasValidationEnabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_SPACE_CONFLICT_CHECKER_SPACE_ALIAS_VALIDATION);
    }

    public boolean isForgeMigrationPathEnabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_FORGE_MIGRATION_PATH);
    }

    public boolean isCloudFirstMigrationEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_CLOUD_FIRST_MIGRATION) || this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_CLOUD_FIRST_MIGRATION);
    }

    public boolean isCloudFirstMigrationDomainReviewEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_CLOUD_FIRST_MIGRATION_DOMAIN_REVIEW);
    }

    public Boolean isAppDataUploadCacheEnabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_APP_DATA_UPLOAD_CACHE);
    }

    public boolean isNewAssessmentStatusDisabled() {
        return !this.isFeatureEnabled(FeatureFlags.ENABLE_NEW_ASSESSMENT_STATUS) && !this.isFeatureEnabled(FeatureFlags.ENABLE_BROWSER_METRICS);
    }

    public boolean isPortfolioAnalysisUiEnabled() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_PORTFOLIO_ANALYSIS_UI);
    }

    public boolean isBatchAppDataRequestsToAppAggregatorServiceEnabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_BATCH_APP_DATA_REQUESTS_TO_APP_AGGREGATOR_SERVICE);
    }

    public boolean isReadingSpaceUploadFileConfigFromDBDisabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.DISABLE_READING_SPACE_UPLOAD_FILE_CONFIG_FROM_DB) || this.isFeatureEnabled(FeatureFlags.DISABLE_READING_SPACE_UPLOAD_FILE_CONFIG_FROM_DB);
    }

    public boolean isUserCsvMergeEnabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_USER_CSV_MERGE) || this.isFeatureEnabled(FeatureFlags.ENABLE_USER_CSV_MERGE);
    }

    public boolean enableBrokenSequenceFilter() {
        return this.isFeatureEnabled(FeatureFlags.ENABLE_BROKEN_SEQUENCE_FILTER);
    }

    public boolean enableSkippingMigratedTeamCalendars() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_SKIPPING_MIGRATED_TEAM_CALENDARS);
    }

    public boolean disableSafeDeserialization() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.DISABLE_SAFE_DESERIALIZATION, true);
    }

    public boolean keepFileNameAsParamToMediaAPI() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.KEEP_FILENAME_AS_PARAM_TO_MEDIA_API, true);
    }

    public boolean isInfraOptimisationEnabled(Plan plan) {
        this.fx3Helper.updateUserCustomAttributes(plan);
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_RDS_INFRA_OPTIMISATION, false);
    }

    public boolean isMediaRampUpEnabled() {
        return this.featureFlagClient.isFeatureEnabled(FeatureFlags.ENABLE_MEDIA_RAMP_UP, false);
    }

    public static enum FeatureFlags {
        HANDLE_INVALID_DUPLICATE_EMAIL_USERS("migration-assistant.handle-invalid-duplicate-email-users"),
        APP_MIGRATION_DEV_MODE("migration-assistant.app-migration.dev-mode"),
        DISABLE_MISSING_ATTACHMENTS_CHECK("migration-assistant.disable.missing-attachments-check"),
        DISABLE_APP_OUTDATED_CHECK("migration-assistant.disable.app-outdated-check"),
        DISABLE_TASK_LIST_FEATURE("migration-assistant.disable.task-list.feature"),
        ENABLE_EXPORT_ONLY("migration-assistant.enable.export-only"),
        ENABLE_UPLOAD_ONLY("migration-assistant.enable.upload-only"),
        SKIP_ATTACHMENTS_UPLOAD("migration-assistant.skip.attachments.upload"),
        DISABLE_APP_VENDOR_CHECK("migration-assistant.disable.app-vendor-check"),
        ENABLE_V4_MIGRATION_PROTOCOL("migration-assistant-enable-v4-migration-protocol"),
        ENABLE_APP_VENDOR_CHECK_FILTER("enable.app-vendor-check-filter"),
        ENABLE_BROWSER_METRICS("migration-assistant.enable.assess-l1-cloud-tooling.feature"),
        QUICK_ASSESSMENT("migration-assistant.assess.quick"),
        DISABLE_CHECKS_BEFORE_RUN("migration-assistant.disable.checks-before-run"),
        ENABLE_SPACE_USERS_MIGRATIONS_STEP("migration-assistant.enable.space-users-migration-step"),
        DISABLE_LICENCE_CHECK("migration-assistant.disable.licence-check"),
        DISABLE_NEW_SPACE_SELECTOR("migration-assistant.disable.new-space-selector-feature"),
        ENABLE_FED_RAMP("migration-assistant.enable.fedRAMP"),
        ENABLE_FORCE_RESET_FLAG("migration-assistant.enable.force-reset-flag"),
        ENABLE_TOKEN_ENCRYPTION("migration-assistant.enable.token.encryption"),
        DISABLE_TEAM_CALENDARS_MIGRATION("migration-assistant.disable.team-calendars-migration"),
        ENABLE_RELATIONS_ANALYSIS("migration-assistant.enable.relations.analysis"),
        ENABLE_RELATIONS_ANALYSIS_DURING_INSTANCE_ASSESSMENT("migration-assistant.enable.relations.analysis.during.instance.assessment"),
        DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS("migration-assistant.disable.relations.analysis.user-group-keys"),
        DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS_HASHING("migration-assistant.disable.relations.analysis.user-group-keys.hashing"),
        ENABLE_FORGE_MIGRATION_PATH("migration-assistant.enable.forge.migration.path"),
        ENABLE_PARALLEL_APP_DATA_UPLOADS("migration-assistant.enable.parallel.app.data.uploads"),
        ENABLE_SPACE_CONFLICT_CHECKER_SPACE_ALIAS_VALIDATION("migration-assistant.enable.space.conflict.checker.space.alias.validation"),
        ENABLE_CLOUD_FIRST_MIGRATION("migration-assistant-enable-cloud-first-migration"),
        ENABLE_CLOUD_FIRST_MIGRATION_DOMAIN_REVIEW("migration-assistant.enable.cloud.first.migration.domain-review"),
        ENABLE_APP_DATA_UPLOAD_CACHE("migration-assistant.cached.app.upload"),
        ENABLE_NEW_ASSESSMENT_STATUS("migration-assistant.new.assessment.status"),
        ENABLE_PORTFOLIO_ANALYSIS_UI("migration-assistant.enable.relations.analysis.during.instance.assessment.ui"),
        ENABLE_BATCH_APP_DATA_REQUESTS_TO_APP_AGGREGATOR_SERVICE("migration-assistant.batch.app.data.requests.to.app.aggregator.service"),
        ENABLE_USER_CSV_MERGE("migration-assistant.enable.user.csv.merge"),
        ENABLE_MD5_PART_UPLOAD("migration-assistant.enable.md5.part.upload"),
        DISABLE_READING_SPACE_UPLOAD_FILE_CONFIG_FROM_DB("migration-assistant.disable.reading.space.upload.file.config.from.db"),
        ENABLE_BROKEN_SEQUENCE_FILTER("migration-assistant.enable.broken.sequence.filter"),
        ENABLE_SKIPPING_MIGRATED_TEAM_CALENDARS("migration-assistant-skip-migrated-team-calendars"),
        MIGRATION_ASSISTANT_DISABLE_GLOBAL_EMAIL_FIXES_FEATURE("migration-assistant.disable.global.email.fixes.feature"),
        MIGRATION_ASSISTANT_ENABLE_NEW_EMAILS_FROM_DB("migration-assistant.global.email.fixes.new-email-from-db.feature"),
        MIGRATION_ASSISTANT_DISABLE_UMS_CHECK_FOR_TRUSTED_DOMAINS("migration-assistant.disable.ums.blocked.domain.preflight.check"),
        MIGRATION_ASSISTANT_ENABLE_EXTENDED_UMS_TIMEOUT("migration-assistant.enable.extended.ums.timeout"),
        DISABLE_SAFE_DESERIALIZATION("migration-assistant-disable-safe-deserialization"),
        KEEP_FILENAME_AS_PARAM_TO_MEDIA_API("migration-assistant-keep-filename-param-to-mediav2"),
        SHOW_TROUBLESHOOTING_LINK("migration-assistant-show-troubleshooting-link"),
        ENABLE_RDS_INFRA_OPTIMISATION("migration-assistant-enable-infra-optimisation"),
        ENABLE_MEDIA_RAMP_UP("migration-assistant-enable-media-ramp-up");

        private final String flagName;

        private FeatureFlags(String flagName) {
            this.flagName = flagName;
        }

        public String getFlagName() {
            return this.flagName;
        }
    }
}

