/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.InProgressMigration;
import com.atlassian.migration.agent.v4.MigrationTerminator;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProgressMigrationIds {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InProgressMigrationIds.class);
    private static final String CACHE_NAME = "com.atlassian.migration.agent.v4.inProgressMigrations.cache";
    private static final String CACHE_KEY_INPROGRESS_MIGRATION = "inProgressMigrations";
    public static final Duration MAX_IN_PROGRESS_MIGRATION_WINDOW = Duration.ofDays(7L);
    private PlanStore planStore;
    private Supplier<Cache<String, String>> cache;
    private MigrationTerminator migrationTerminator;
    private PluginTransactionTemplate ptx;

    public InProgressMigrationIds(PlanStore planStore, CacheManager cacheManager, MigrationTerminator migrationTerminator, PluginTransactionTemplate ptx) {
        this.planStore = planStore;
        this.migrationTerminator = migrationTerminator;
        this.ptx = ptx;
        this.cache = Lazy.supplier(() -> cacheManager.getCache(CACHE_NAME, null, new CacheSettingsBuilder().replicateViaCopy().expireAfterWrite(1L, TimeUnit.MINUTES).remote().build()));
    }

    public void clear() {
        ((Cache)this.cache.get()).removeAll();
    }

    public Stream<InProgressMigration> sequence() {
        String inProgressMigrationsJson = (String)((Cache)this.cache.get()).get((Object)CACHE_KEY_INPROGRESS_MIGRATION, () -> this.ptx.read(() -> {
            List<Plan> plans = this.planStore.getPlans((List<ExecutionStatus>)ImmutableList.of((Object)((Object)ExecutionStatus.RUNNING)));
            ArrayList<Plan> freshPlans = new ArrayList<Plan>();
            for (Plan plan : plans) {
                if (this.isStale(plan)) {
                    log.info("Stale plan - todo proper log");
                    this.migrationTerminator.terminateMigration(plan.getId(), Optional.of(plan), "Migration has timed out. Create a new migration and run the migration again.");
                    continue;
                }
                freshPlans.add(plan);
            }
            List inProgressMigrationList = freshPlans.stream().map(p -> new InProgressMigration(p.getId(), p.getMigrationId(), p.getMigrationProtocol(), p.getCloudSite())).collect(Collectors.toList());
            return Jsons.valueAsString(inProgressMigrationList);
        }));
        List inProgressMigrationList = (List)Jsons.readValue(inProgressMigrationsJson, (TypeReference)new TypeReference<List<InProgressMigration>>(){});
        return inProgressMigrationList.stream();
    }

    private boolean isStale(Plan plan) {
        return plan.getLastUpdate().isBefore(Instant.now().minus(MAX_IN_PROGRESS_MIGRATION_WINDOW));
    }

    @PreDestroy
    public void destroy() {
        this.clear();
    }
}

