/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.migration.agent.service.email.IncorrectEmailDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;

public class IncorrectEmailResponse {
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final String scanId;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final int page;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final int perPage;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final long pagesCount;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final long totalCount;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final List<IncorrectEmailDTO> data;

    public IncorrectEmailResponse(String scanId, int page, int perPage, long totalCount, List<IncorrectEmailDTO> data) {
        this.scanId = scanId;
        this.page = page;
        this.perPage = perPage;
        this.pagesCount = this.calculatePagesCount(perPage, totalCount);
        this.totalCount = totalCount;
        this.data = data;
    }

    private long calculatePagesCount(int limit, long count) {
        return (long)Math.ceil((double)count / (double)limit);
    }

    @Generated
    public String getScanId() {
        return this.scanId;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public int getPerPage() {
        return this.perPage;
    }

    @Generated
    public long getPagesCount() {
        return this.pagesCount;
    }

    @Generated
    public long getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public List<IncorrectEmailDTO> getData() {
        return this.data;
    }
}

