/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.model.ConfluenceShardResponse;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class MigrationPlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationPlatformService.class);
    private static final String GET_CONTAINER_TOKEN_VALIDITY_PATH = "/token/validation";
    private static final String CONFLUENCE = "confluence";
    private static final String SHARD = "shard";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;

    public MigrationPlatformService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        this(new HttpService(() -> MigrationPlatformService.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder)), configuration);
    }

    @VisibleForTesting
    MigrationPlatformService(HttpService httpService, MigrationAgentConfiguration configuration) {
        this.httpService = httpService;
        this.configuration = configuration;
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(60L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationServiceBaseUrl());
    }

    public Date getContainerTokenExpiry(String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path(GET_CONTAINER_TOKEN_VALIDITY_PATH).toUriString()).addHeader("Accept", "application/json").addHeader("credential.username", "x-container-token").get().build();
        return this.callJsonWithRetries(request, new TypeReference<ContainerTokenExpiryResponse>(){}).expiry;
    }

    public ConfluenceShardResponse getConfluenceShardDetails(String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().pathSegment(new String[]{CONFLUENCE, SHARD}).toUriString()).addHeader("Accept", "application/json").addHeader("credential.username", "x-container-token").get().build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceShardResponse>(){});
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)Failsafe.with(RetryPolicyBuilder.policyForMigrationServices(), (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callJson(request, bodyType));
    }

    static class ContainerTokenExpiryResponse {
        private Date expiry;

        @org.codehaus.jackson.annotate.JsonCreator
        @JsonCreator
        ContainerTokenExpiryResponse(@org.codehaus.jackson.annotate.JsonProperty(value="expiry") @JsonProperty(value="expiry") Date expiry) {
            this.expiry = expiry;
        }
    }
}

