/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.portfolioanalyzer.service;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.portfolioanalyzer.model.SpaceRelationsGraph;
import com.atlassian.migration.agent.service.portfolioanalyzer.service.RelationsAnalyzerService;
import com.atlassian.migration.agent.service.portfolioanalyzer.service.WarnLogFileWriter;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationsAnalyzerRunner
implements JobRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelationsAnalyzerRunner.class);
    static final String APPLICATION_USER_PARAM = "APPLICATION_USER";
    static final String SERVER_NODE = "SERVER_NODE";
    private final SchedulerService schedulerService;
    private final RelationsAnalyzerService relationsAnalyzerService;
    private final UserAccessor userAccessor;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final WarnLogFileWriter warnLogFileWriter;
    private final Config config;
    private final ClusterManager clusterManager;

    public RelationsAnalyzerRunner(Config config, SchedulerService schedulerService, RelationsAnalyzerService relationsAnalyzerService, UserAccessor userAccessor, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, WarnLogFileWriter warnLogFileWriter, ClusterManager clusterManager) {
        this.schedulerService = schedulerService;
        this.relationsAnalyzerService = relationsAnalyzerService;
        this.userAccessor = userAccessor;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.warnLogFileWriter = warnLogFileWriter;
        this.config = config;
        this.clusterManager = clusterManager;
    }

    private JobConfig jobConfigOf(JobRunnerKey jobRunnerKey) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)APPLICATION_USER_PARAM, (Object)AuthenticatedUserThreadLocal.get().getKey().getStringValue(), (Object)SERVER_NODE, (Object)this.getNodeIdOrDefault()));
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(this.config.jobRunnerKey, (JobRunner)this);
        this.cancelActiveNodeJobs();
    }

    @PreDestroy
    public void cleanup() {
        this.cancelActiveNodeJobs();
        this.schedulerService.unregisterJobRunner(this.config.jobRunnerKey);
    }

    private void cancelActiveNodeJobs() {
        String nodeId = this.getNodeIdOrDefault();
        log.info("Cancelling active node jobs - nodeId: {}", (Object)nodeId);
        this.schedulerService.getJobsByJobRunnerKey(this.config.jobRunnerKey).stream().filter(it -> {
            Serializable schedulingNodeId = (Serializable)it.getParameters().get(SERVER_NODE);
            return schedulingNodeId == null || schedulingNodeId.equals(nodeId) || !this.isNodePresent((String)((Object)schedulingNodeId));
        }).forEach(it -> {
            log.info("Cancelling job - jobId: {} - serverNode: {}", (Object)this.config.jobId, (Object)nodeId);
            this.schedulerService.unscheduleJob(it.getJobId());
        });
        log.info("Finished cancelling active node jobs - nodeId: {}", (Object)nodeId);
    }

    public Try<JobId> scheduleJob() {
        if (!this.isAnyActiveJob()) {
            try {
                this.schedulerService.scheduleJob(this.config.jobId, this.jobConfigOf(this.config.jobRunnerKey));
                return Try.successful((Object)this.config.jobId);
            }
            catch (SchedulerServiceException e) {
                log.error("Error occurred when scheduling job", (Throwable)e);
                return Try.failure((Exception)((Object)e));
            }
        }
        return Try.failure((Exception)new IllegalStateException("Job already scheduled"));
    }

    public Status getJobStatus() {
        if (this.isAnyActiveJob()) {
            return Status.IN_PROGRESS;
        }
        if (Files.exists(this.config.jsonFilePath, new LinkOption[0])) {
            return Status.COMPLETED;
        }
        if (Files.exists(this.config.errorFilePath, new LinkOption[0])) {
            return Status.ERROR;
        }
        return Status.UNKNOWN;
    }

    public Instant getCompletedTimestamp() {
        Preconditions.checkState((this.getJobStatus() == Status.COMPLETED ? 1 : 0) != 0, (Object)"Relations assessment is not completed");
        if (Files.exists(this.config.jsonFilePath, new LinkOption[0])) {
            return this.getFileLastModifiedTime(this.config.jsonFilePath);
        }
        if (Files.exists(this.config.errorFilePath, new LinkOption[0])) {
            return this.getFileLastModifiedTime(this.config.errorFilePath);
        }
        throw new IllegalStateException("Could not obtain relations assessment completed timestamp");
    }

    private Instant getFileLastModifiedTime(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toInstant();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void generateZip() {
        try {
            this.doGenerateZip();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        this.warnLogFileWriter.clearWarnLogs();
        long startTime = System.currentTimeMillis();
        try {
            UserKey userKey = new UserKey(((Serializable)request.getJobConfig().getParameters().get(APPLICATION_USER_PARAM)).toString());
            AuthenticatedUserThreadLocal.set((ConfluenceUser)this.userAccessor.getUserByKey(userKey));
            SpaceRelationsGraph graph = this.relationsAnalyzerService.getGraph();
            this.removeFilesAndCreateOneWithContent(this.config.jsonFilePath, graph);
            this.logSuccessAndSendEvent(startTime, graph.getNodes().size(), graph.getRelations().size());
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)("Connection graph successfully saved to " + this.config.jsonFilePath + "."));
            return jobRunnerResponse;
        }
        catch (UncheckedIOException e) {
            this.logErrorAndSendEvent(startTime, e);
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)("Failed to run job: " + e.getMessage()));
            return jobRunnerResponse;
        }
        catch (Exception e) {
            this.removeFilesAndCreateOneWithContent(this.config.errorFilePath, ExceptionUtils.getStackTrace((Throwable)e));
            this.logErrorAndSendEvent(startTime, e);
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)("Failed to run job: " + e.getMessage()));
            return jobRunnerResponse;
        }
        finally {
            AuthenticatedUserThreadLocal.reset();
            this.generateZip();
        }
    }

    private void logSuccessAndSendEvent(long startTime, int numberOfNodes, int numberOfRelations) {
        long durationMs = System.currentTimeMillis() - startTime;
        log.info("Successful relations analysis job took {} ms", (Object)durationMs);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildRelationsAnalysisJobFinishedEvent(durationMs, numberOfNodes, numberOfRelations));
    }

    private void logErrorAndSendEvent(long startTime, Throwable e) {
        long durationMs = System.currentTimeMillis() - startTime;
        log.error("Failed relations analysis job took {} ms", (Object)durationMs, (Object)e);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildRelationsAnalysisJobFailedEvent(durationMs));
    }

    private void doGenerateZip() throws IOException {
        Files.deleteIfExists(this.config.zipFilePath);
        List filesToExport = ImmutableList.of((Object)this.config.jsonFilePath.toFile(), (Object)this.config.errorFilePath.toFile(), (Object)this.warnLogFileWriter.getWarnLogFilePath().toFile()).stream().filter(File::exists).collect(Collectors.toList());
        try (FileOutputStream fos = new FileOutputStream(this.config.zipFilePath.toFile());
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (File file : filesToExport) {
                try (FileInputStream fis = new FileInputStream(file);){
                    ZipEntry zipEntry = new ZipEntry(file.getName());
                    zos.putNextEntry(zipEntry);
                    IOUtils.copy((InputStream)fis, (OutputStream)zos);
                    zos.closeEntry();
                }
            }
        }
    }

    private boolean isAnyActiveJob() {
        return !this.schedulerService.getJobsByJobRunnerKey(this.config.jobRunnerKey).isEmpty();
    }

    private void removeFilesAndCreateOneWithContent(Path path, Object content) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Files.deleteIfExists(this.config.jsonFilePath);
            Files.deleteIfExists(this.config.errorFilePath);
            Path pathToCreatedFile = Files.createFile(path, new FileAttribute[0]);
            mapper.writeValue(pathToCreatedFile.toFile(), content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getNodeIdOrDefault() {
        ClusterNodeInformation thisNodeInformation = this.clusterManager.getThisNodeInformation();
        return thisNodeInformation == null ? "defaultClusterNode" : thisNodeInformation.getAnonymizedNodeIdentifier();
    }

    private boolean isNodePresent(String nodeId) {
        return this.clusterManager.getAllNodesInformation().stream().anyMatch(it -> it.getAnonymizedNodeIdentifier().equals(nodeId));
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    public static final class Config {
        private final JobRunnerKey jobRunnerKey;
        private final JobId jobId;
        private final Path jsonFilePath;
        private final Path warnFilePath;
        private final Path errorFilePath;
        private final Path zipFilePath;

        @Generated
        public Config(JobRunnerKey jobRunnerKey, JobId jobId, Path jsonFilePath, Path warnFilePath, Path errorFilePath, Path zipFilePath) {
            this.jobRunnerKey = jobRunnerKey;
            this.jobId = jobId;
            this.jsonFilePath = jsonFilePath;
            this.warnFilePath = warnFilePath;
            this.errorFilePath = errorFilePath;
            this.zipFilePath = zipFilePath;
        }

        @Generated
        public JobRunnerKey getJobRunnerKey() {
            return this.jobRunnerKey;
        }

        @Generated
        public JobId getJobId() {
            return this.jobId;
        }

        @Generated
        public Path getJsonFilePath() {
            return this.jsonFilePath;
        }

        @Generated
        public Path getWarnFilePath() {
            return this.warnFilePath;
        }

        @Generated
        public Path getErrorFilePath() {
            return this.errorFilePath;
        }

        @Generated
        public Path getZipFilePath() {
            return this.zipFilePath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            JobRunnerKey this$jobRunnerKey = this.getJobRunnerKey();
            JobRunnerKey other$jobRunnerKey = other.getJobRunnerKey();
            if (this$jobRunnerKey == null ? other$jobRunnerKey != null : !this$jobRunnerKey.equals(other$jobRunnerKey)) {
                return false;
            }
            JobId this$jobId = this.getJobId();
            JobId other$jobId = other.getJobId();
            if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
                return false;
            }
            Path this$jsonFilePath = this.getJsonFilePath();
            Path other$jsonFilePath = other.getJsonFilePath();
            if (this$jsonFilePath == null ? other$jsonFilePath != null : !((Object)this$jsonFilePath).equals(other$jsonFilePath)) {
                return false;
            }
            Path this$warnFilePath = this.getWarnFilePath();
            Path other$warnFilePath = other.getWarnFilePath();
            if (this$warnFilePath == null ? other$warnFilePath != null : !((Object)this$warnFilePath).equals(other$warnFilePath)) {
                return false;
            }
            Path this$errorFilePath = this.getErrorFilePath();
            Path other$errorFilePath = other.getErrorFilePath();
            if (this$errorFilePath == null ? other$errorFilePath != null : !((Object)this$errorFilePath).equals(other$errorFilePath)) {
                return false;
            }
            Path this$zipFilePath = this.getZipFilePath();
            Path other$zipFilePath = other.getZipFilePath();
            return !(this$zipFilePath == null ? other$zipFilePath != null : !((Object)this$zipFilePath).equals(other$zipFilePath));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JobRunnerKey $jobRunnerKey = this.getJobRunnerKey();
            result = result * 59 + ($jobRunnerKey == null ? 43 : $jobRunnerKey.hashCode());
            JobId $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
            Path $jsonFilePath = this.getJsonFilePath();
            result = result * 59 + ($jsonFilePath == null ? 43 : ((Object)$jsonFilePath).hashCode());
            Path $warnFilePath = this.getWarnFilePath();
            result = result * 59 + ($warnFilePath == null ? 43 : ((Object)$warnFilePath).hashCode());
            Path $errorFilePath = this.getErrorFilePath();
            result = result * 59 + ($errorFilePath == null ? 43 : ((Object)$errorFilePath).hashCode());
            Path $zipFilePath = this.getZipFilePath();
            result = result * 59 + ($zipFilePath == null ? 43 : ((Object)$zipFilePath).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelationsAnalyzerRunner.Config(jobRunnerKey=" + this.getJobRunnerKey() + ", jobId=" + this.getJobId() + ", jsonFilePath=" + this.getJsonFilePath() + ", warnFilePath=" + this.getWarnFilePath() + ", errorFilePath=" + this.getErrorFilePath() + ", zipFilePath=" + this.getZipFilePath() + ")";
        }
    }

    public static enum Status {
        IN_PROGRESS,
        COMPLETED,
        ERROR,
        UNKNOWN;

    }
}

