/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class FedrampAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public FedrampAnalyticsEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier) {
        this(analyticsEventBuilderUtil, senSupplier, Instant::now);
    }

    @VisibleForTesting
    FedrampAnalyticsEventBuilder(AnalyticsEventBuilderUtil analyticsEventBuilderUtil, SENSupplier senSupplier, Supplier<Instant> instantSupplier) {
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
    }

    public EventDto buildUpdatedCloudTypeSettingsAnalyticEvent(String settings) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"cloudTypeSettings", (Object)settings);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("cloudTypeSettingsUpdated")).sen(this.senSupplier.get())).actionSubject("migrationSettings")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildTokenEncryptionFailureAnalyticEvent(String reason) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"reason", (Object)reason);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("tokenEncryption")).sen(this.senSupplier.get())).actionSubject("failed")).withAttributes((Map)attributes.build())).build();
    }
}

