/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsService;
import com.atlassian.migration.agent.v4.migration.MigrationTracker;
import com.atlassian.migration.agent.v4.pollers.DefaultPollingSettings;
import com.atlassian.migration.agent.v4.pollers.PollerConfig;
import com.atlassian.migration.agent.v4.worker.AttachmentUploadWorker;
import com.atlassian.migration.agent.v4.worker.UsersGroupsUploadWorker;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingSetup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PollingSetup.class);
    private ClusterManager clusterManager;
    private ConcurrencySettingsService concurrencySettingsService;
    private AttachmentUploadWorker attachmentOnlyUploadWorker;
    private UsersGroupsUploadWorker usersGroupsUploadWorker;
    private MigrationTracker tracker;

    public PollingSetup(ClusterManager clusterManager, ConcurrencySettingsService concurrencySettingsService, AttachmentUploadWorker attachmentOnlyUploadWorker, UsersGroupsUploadWorker usersGroupsUploadWorker, MigrationTracker tracker) {
        this.clusterManager = clusterManager;
        this.concurrencySettingsService = concurrencySettingsService;
        this.attachmentOnlyUploadWorker = attachmentOnlyUploadWorker;
        this.usersGroupsUploadWorker = usersGroupsUploadWorker;
        this.tracker = tracker;
    }

    public void init() {
        log.info("Initializing pollers");
        Duration workerPollingDelay = this.clusterManager.isClustered() ? DefaultPollingSettings.DEFAULT_CLUSTERED_POLLING_DELAY : DefaultPollingSettings.DEFAULT_POLLING_DELAY;
        this.tracker.clearInProgressMigrationIds();
        this.tracker.addAndStartWorkPoller(new PollerConfig(workerPollingDelay, 1, this.concurrencySettingsService.getAttachmentMigrationConcurrencyNodeMax()), this.attachmentOnlyUploadWorker);
        this.tracker.addAndStartWorkPoller(new PollerConfig(workerPollingDelay, 1, 1), this.usersGroupsUploadWorker);
        this.tracker.addAndStartStatusPoller(new PollerConfig(DefaultPollingSettings.DEFAULT_STATUS_POLLING_DELAY, 1, 1));
        log.info("Pollers were successfully initialized!");
    }
}

