/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.edition;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.edition.CloudPremiumEditionChecker;
import com.atlassian.migration.agent.service.check.edition.CloudPremiumEditionContext;
import com.atlassian.migration.agent.service.check.edition.CloudPremiumEditionContextProvider;
import com.atlassian.migration.agent.service.check.edition.CloudPremiumEditionMapper;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.user.RetryingUsersMigrationService;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CloudPremiumEditionRegistration
implements CheckRegistration<CloudPremiumEditionContext> {
    private final CloudPremiumEditionChecker checker;
    private final CloudPremiumEditionContextProvider contextProvider;
    private final CloudPremiumEditionMapper resultMapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    public CloudPremiumEditionRegistration(PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder, CloudSiteService cloudSiteService, RetryingUsersMigrationService usersMigrationService) {
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
        this.checker = new CloudPremiumEditionChecker(cloudSiteService, usersMigrationService);
        this.resultMapper = new CloudPremiumEditionMapper();
        this.contextProvider = new CloudPremiumEditionContextProvider();
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.CLOUD_PREMIUM_EDITION;
    }

    @Override
    public Checker<CloudPremiumEditionContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<CloudPremiumEditionContext> getCheckContextProvider() {
        return this.contextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.resultMapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(CheckResult checkResult, long totalTime) {
        String edition = (String)checkResult.details.get("edition");
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightCloudPremiumEditionCheck(checkResult.success, totalTime, edition);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "cloudPremiumEditionCheck";
    }
}

