/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.utils;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.entity.IncorrectEmail;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.email.EmailCheckType;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.udc.common.model.correctedemails.CorrectedEmail;
import com.atlassian.migration.udc.common.model.user.User;
import com.atlassian.migration.udc.common.model.userbasescan.ScanStatus;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class UDCMapperUtils {
    private UDCMapperUtils() {
    }

    public static User toUser(ConfluenceUser confluenceUser, boolean active) {
        return new User(confluenceUser.getEmail(), confluenceUser.getFullName(), active, confluenceUser.getName(), confluenceUser.getKey().getStringValue());
    }

    public static List<MigrationUser> toMigrationUsers(List<User> users) {
        return users.stream().map(user -> new MigrationUser(user.getUserKey(), user.getUserName(), user.getFullName(), user.getEmail(), user.getActive())).collect(Collectors.toList());
    }

    public static User toUser(MigrationUser migrationUser) {
        return new User(migrationUser.getEmail(), migrationUser.getFullName(), migrationUser.isActive(), migrationUser.getUsername(), migrationUser.getUserKey());
    }

    public static CheckType toCheckType(com.atlassian.migration.udc.common.model.EmailCheckType checkType) {
        switch (checkType) {
            case INV: {
                return CheckType.INVALID_EMAILS;
            }
            case DUP: {
                return CheckType.SHARED_EMAILS;
            }
        }
        throw new IllegalArgumentException("Unknown check type: " + checkType);
    }

    public static com.atlassian.migration.udc.common.model.EmailCheckType toEmailCheckType(CheckType checkType) {
        if (checkType.equals(CheckType.INVALID_EMAILS)) {
            return com.atlassian.migration.udc.common.model.EmailCheckType.INV;
        }
        if (checkType.equals(CheckType.SHARED_EMAILS)) {
            return com.atlassian.migration.udc.common.model.EmailCheckType.DUP;
        }
        throw new IllegalArgumentException("Unknown check type: " + checkType);
    }

    public static com.atlassian.migration.udc.common.model.incorrectemail.IncorrectEmail toIncorrectEmail(IncorrectEmail it) {
        return new com.atlassian.migration.udc.common.model.incorrectemail.IncorrectEmail(it.getScanId(), it.getUserKey(), UDCMapperUtils.toEmailCheckType(it.getCheckType()), it.getCheckType().value(), it.getUserName(), it.getEmail(), it.getNewEmail(), it.getDirectoryName(), it.getLastAuthenticated());
    }

    public static ScanStatus toScanStatus(com.atlassian.migration.agent.entity.ScanStatus status) {
        return ScanStatus.valueOf((String)status.name());
    }

    public static UserBaseScan toUserBaseScan(com.atlassian.migration.agent.entity.UserBaseScan scan) {
        return new UserBaseScan(UDCMapperUtils.toScanStatus(scan.getStatus()), scan.getStarted().toEpochMilli(), scan.getFinished() == null ? 0L : scan.getFinished().toEpochMilli(), scan.getInvalidUsers(), scan.getDuplicateUsers(), 0L, 0L, scan.getId());
    }

    public static CorrectedEmail toCorrectedEmail(com.atlassian.migration.agent.entity.CorrectedEmail ce) {
        return new CorrectedEmail(ce.getUserKey(), ce.getUserName(), ce.getType() == null ? null : UDCMapperUtils.toEmailCheckType(ce.getType()), ce.getOldEmail(), ce.getNewEmail(), ce.getTombstone().booleanValue(), ce.getAccountType(), ce.getUdcMode(), ce.getDraft().booleanValue(), UUID.fromString(ce.getId()));
    }

    public static com.atlassian.migration.agent.entity.CorrectedEmail toCorrectedEmail(CorrectedEmail ce) {
        return new com.atlassian.migration.agent.entity.CorrectedEmail(ce.getKey(), ce.getUserName(), ce.getType() == null ? null : UDCMapperUtils.toEmailCheckType(ce.getType()), ce.getOldEmail(), ce.getNewEmail(), ce.getTombstone(), ce.getAccountType(), ce.getUdcMode(), ce.getDraft());
    }

    public static EmailCheckType toEmailCheckType(com.atlassian.migration.udc.common.model.EmailCheckType checkType) {
        switch (checkType) {
            case INV: {
                return EmailCheckType.INV;
            }
            case DUP: {
                return EmailCheckType.DUP;
            }
        }
        throw new IllegalArgumentException("Unknown check type: " + checkType);
    }

    public static com.atlassian.migration.udc.common.model.EmailCheckType toEmailCheckType(EmailCheckType checkType) {
        switch (checkType) {
            case INV: {
                return com.atlassian.migration.udc.common.model.EmailCheckType.INV;
            }
            case DUP: {
                return com.atlassian.migration.udc.common.model.EmailCheckType.DUP;
            }
        }
        throw new IllegalArgumentException("Unknown check type: " + (Object)((Object)checkType));
    }
}

