/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.fx3.Fx3Client;
import com.atlassian.fx3.httpclient.HttpCallback;
import com.atlassian.fx3.setup.Fx3Config;
import com.atlassian.fx3.statsig.StatsigIdentifierType;
import com.atlassian.migration.agent.config.url.MigrationEnvironment;
import com.atlassian.migration.agent.config.url.MigrationUrlProviderFactory;
import com.atlassian.migration.agent.service.featureflag.Fx3OkhttpAdapter;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fx3ClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Fx3ClientFactory.class);
    private final Fx3OkhttpAdapter fx3OkhttpAdapter;
    private final MigrationUrlProviderFactory migrationUrlProviderFactory;
    private final LicenseHandler licenseHandler;
    private final PluginVersionManager pluginVersionManager;

    public Fx3ClientFactory(Fx3OkhttpAdapter fx3OkhttpAdapter, MigrationUrlProviderFactory migrationUrlProviderFactory, LicenseHandler licenseHandler, PluginVersionManager pluginVersionManager) {
        this.fx3OkhttpAdapter = fx3OkhttpAdapter;
        this.migrationUrlProviderFactory = migrationUrlProviderFactory;
        this.licenseHandler = licenseHandler;
        this.pluginVersionManager = pluginVersionManager;
    }

    public Fx3Client createFx3Client(MigrationEnvironment environment) {
        try {
            Fx3Config fx3Config = new Fx3Config(this.migrationUrlProviderFactory.getUrlProvider(environment).getFx3baseUrl(), this.migrationUrlProviderFactory.getUrlProvider(environment).getFx3EnvironmentKey(), this.migrationUrlProviderFactory.getUrlProvider(environment).getStatsigApiKey(), this.migrationUrlProviderFactory.getUrlProvider(environment).getDefaultStatsigAppName());
            Map<String, Object> customAttributes = this.createCustomAttributesMap();
            return Fx3Client.Companion.init(fx3Config, customAttributes, (HttpCallback)this.fx3OkhttpAdapter, (Map)ImmutableMap.of((Object)StatsigIdentifierType.TENANT_ID, (Object)"dummy initial value"));
        }
        catch (Exception e) {
            log.error("Error occurred while initializing Fx3Client and only defaults will be used.", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> createCustomAttributesMap() {
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        customAttributes.put("ServerId", this.licenseHandler.getServerId());
        customAttributes.put("PluginVersion", this.pluginVersionManager.getPluginVersion());
        Optional.ofNullable(this.getConfluenceLicenseType()).ifPresent(licenseType -> customAttributes.put("LicenseType", licenseType));
        Optional.ofNullable(this.getConfluenceLicenseUsers()).ifPresent(licenseUsers -> customAttributes.put("LicenseUsers", licenseUsers));
        return customAttributes;
    }

    private String getConfluenceLicenseType() {
        try {
            SingleProductLicenseDetailsView licenseDetails = this.licenseHandler.getProductLicenseDetails("conf");
            return licenseDetails != null ? licenseDetails.getLicenseTypeName() : null;
        }
        catch (Exception ex) {
            log.error("Error occurred while getting Confluence license details", (Throwable)ex);
            return null;
        }
    }

    private Integer getConfluenceLicenseUsers() {
        try {
            SingleProductLicenseDetailsView licenseDetails = this.licenseHandler.getProductLicenseDetails("conf");
            return licenseDetails != null ? Integer.valueOf(licenseDetails.getNumberOfUsers()) : null;
        }
        catch (Exception ex) {
            log.error("Error occurred while getting Confluence license details", (Throwable)ex);
            return null;
        }
    }
}

