/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mapi.executor;

import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.migration.agent.entity.MapiTaskMapping;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.mapi.entity.MapiCheckDetailsDto;
import com.atlassian.migration.agent.mapi.entity.MapiOutcome;
import com.atlassian.migration.agent.mapi.entity.MapiStatus;
import com.atlassian.migration.agent.mapi.entity.MapiStatusDto;
import com.atlassian.migration.agent.service.check.CheckOverrideService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.migration.agent.service.prc.model.CommandName;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapiStatusTranslator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapiStatusTranslator.class);
    private static final String SPACE_ANONYMOUS_PERMISSIONS = "Some of your spaces allow anonymous access. In case you exclude this check, such spaces will have public access on cloud, This means they will be available to anyone on the internet after you migrate.";
    private static final String MISSING_ATTACHMENTS = "In case you exclude this check, your spaces will be migrated without the missing attachments.";
    private static final String GLOBAL_DATA_TEMPLATE_CONFLICT = "In case you exclude this check, duplicate global templates would be removed from this migration.";
    public static final int MAX_OCCURRENCES_TO_SEND = 100;
    private final Predicate<String> IS_CHECK_TYPE_COMMAND = command -> CommandName.CHECK.getName().equals(command);
    private final PreflightService preflightService;
    private final CheckOverrideService checkOverrideService;

    public MapiStatusTranslator(PreflightService preflightService, CheckOverrideService checkOverrideService) {
        this.preflightService = preflightService;
        this.checkOverrideService = checkOverrideService;
    }

    public List<MapiStatusDto> translate(MapiTaskMapping mapiTaskMapping) {
        String taskId = mapiTaskMapping.getTaskId();
        String commandName = mapiTaskMapping.getCommandName();
        List<CheckResultDto> results = this.preflightService.getCheckExecutionStatus(commandName.equals(CommandName.CHECK.getName()) ? taskId : mapiTaskMapping.getPlanId());
        List<CheckResultDto> overriddenResults = this.checkOverrideService.applyAndOverride(mapiTaskMapping.getPlanId(), results);
        return overriddenResults.stream().map(checkResultDto -> this.convertCheckResultDtoToMapiStatusDto((CheckResultDto)checkResultDto, commandName)).collect(Collectors.toList());
    }

    private MapiStatusDto convertCheckResultDtoToMapiStatusDto(CheckResultDto checkResultDto, String commandName) {
        Pair<MapiStatus, MapiOutcome> mapiStatus = this.convertCheckResultStatusToMapiStatus(checkResultDto.getStatus());
        MapiCheckDetailsDto mapiCheckDetailsDto = null;
        List<String> occurrencesAsString = this.getCheckResultDetails(checkResultDto);
        if (occurrencesAsString != null && !occurrencesAsString.isEmpty()) {
            mapiCheckDetailsDto = new MapiCheckDetailsDto();
            mapiCheckDetailsDto.setOccurrences(occurrencesAsString);
        }
        if (this.IS_CHECK_TYPE_COMMAND.test(commandName) && this.checkOverrideService.isOverridableCheckType(checkResultDto.getCheckType(), checkResultDto.getStatus())) {
            if (mapiCheckDetailsDto == null) {
                mapiCheckDetailsDto = new MapiCheckDetailsDto();
            }
            mapiCheckDetailsDto.setExcludable(true);
            mapiCheckDetailsDto.setDescription(this.getWarningMessage(checkResultDto.getCheckType()));
        }
        ImmutableList level = commandName.equals(CommandName.CHECK.getName()) ? ImmutableList.of((Object)checkResultDto.getCheckType()) : ImmutableList.of((Object)"check", (Object)checkResultDto.getCheckType());
        return new MapiStatusDto((List<String>)level, (MapiStatus)((Object)mapiStatus.getLeft()), (MapiOutcome)((Object)mapiStatus.getRight()), checkResultDto.getDescription(), mapiCheckDetailsDto, null, System.currentTimeMillis());
    }

    private String getWarningMessage(String checkType) {
        switch (checkType) {
            case "SpaceAnonymousPermissions": {
                return SPACE_ANONYMOUS_PERMISSIONS;
            }
            case "MissingAttachments": {
                return MISSING_ATTACHMENTS;
            }
            case "GlobalDataTemplateConflict": {
                return GLOBAL_DATA_TEMPLATE_CONFLICT;
            }
        }
        return "The given checkType does\u2019t exist";
    }

    private List<String> getCheckResultDetails(CheckResultDto checkResultDto) {
        List listOfOccurrences;
        List list = listOfOccurrences = checkResultDto.getDetails() != null ? checkResultDto.getDetails().getListOfOccurrences() : null;
        if (listOfOccurrences == null || listOfOccurrences.isEmpty()) {
            return Collections.emptyList();
        }
        String checkType = checkResultDto.getCheckType();
        boolean allStrings = listOfOccurrences.stream().allMatch(element -> element instanceof String);
        if (allStrings) {
            return listOfOccurrences.stream().map(element -> (String)element).limit(100L).collect(Collectors.toList());
        }
        if (checkType.equals(CheckType.INVALID_EMAILS.value()) || checkType.equals(CheckType.SHARED_EMAILS.value())) {
            return this.getOccurrencesWithSpecificAttribute(listOfOccurrences, "email");
        }
        List<String> occurrencesWithKey = this.getOccurrencesWithSpecificAttribute(listOfOccurrences, "key");
        if (occurrencesWithKey.isEmpty()) {
            return this.getOccurrencesWithSpecificAttribute(listOfOccurrences, "name");
        }
        return occurrencesWithKey;
    }

    private List<String> getOccurrencesWithSpecificAttribute(List<Object> listOfOccurrences, String attribute) {
        ArrayList<String> occurrences = new ArrayList<String>();
        for (Object detail : listOfOccurrences) {
            try {
                Map map = Jsons.convertValue(detail, Map.class);
                if (map.containsKey(attribute)) {
                    occurrences.add(map.get(attribute).toString());
                }
                if (occurrences.size() < 100) continue;
                return occurrences;
            }
            catch (Exception e) {
                log.error("Unable to convert listOfOccurrences to map", (Throwable)e);
                return Collections.emptyList();
            }
        }
        return occurrences;
    }

    private Pair<MapiStatus, MapiOutcome> convertCheckResultStatusToMapiStatus(Status status) {
        switch (status) {
            case RUNNING: {
                return Pair.of((Object)((Object)MapiStatus.IN_PROGRESS), null);
            }
            case SUCCESS: {
                return Pair.of((Object)((Object)MapiStatus.FINISHED), (Object)((Object)MapiOutcome.SUCCESS));
            }
            case WARNING: {
                return Pair.of((Object)((Object)MapiStatus.FINISHED), (Object)((Object)MapiOutcome.WARNING));
            }
            case ERROR: 
            case EXECUTION_ERROR: {
                return Pair.of((Object)((Object)MapiStatus.FINISHED), (Object)((Object)MapiOutcome.FAILED));
            }
        }
        throw new IllegalArgumentException("Unknown execution status " + status.name());
    }
}

