/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.v4.pollers.PollingSetup;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.EnumSet;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class PluginLauncher
implements LifecycleAware,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginLauncher.class);
    @Generated
    private final Object $lock = new Object[0];
    @GuardedBy(value="this")
    private EnumSet<LifecycleEvent> lifecycleEvents = EnumSet.noneOf(LifecycleEvent.class);
    private final PollingSetup pollingSetup;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final EventPublisher eventPublisher;

    public PluginLauncher(PollingSetup pollingSetup, EventPublisher eventPublisher, MigrationAgentConfiguration migrationAgentConfiguration) {
        this.pollingSetup = pollingSetup;
        this.eventPublisher = eventPublisher;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
    }

    public void onStart() {
        this.onLifecycleEvent(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    public void onStop() {
        log.info("Confluence Migration Plugin ${confluenceMigrationVersionService.pluginVersion} stopped");
        this.unregisterListener();
        this.lifecycleEvents.clear();
    }

    public void afterPropertiesSet() {
        this.registerListener();
        this.onLifecycleEvent(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (event.getPlugin().getKey().equals(this.migrationAgentConfiguration.getPluginKey())) {
            this.onLifecycleEvent(LifecycleEvent.PLUGIN_ENABLED);
        }
    }

    @PreDestroy
    public void destroy() {
        this.unregisterListener();
    }

    private void onLifecycleEvent(LifecycleEvent event) {
        log.info("Life cycle event {} received", (Object)event);
        if (this.isLifecycleReady(event)) {
            this.unregisterListener();
            try {
                this.launch();
            }
            catch (Exception ex) {
                log.error("Unexpected error during launch of plugin", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLifecycleReady(LifecycleEvent event) {
        Object object = this.$lock;
        synchronized (object) {
            return this.lifecycleEvents.add(event) && this.lifecycleEvents.size() == LifecycleEvent.values().length;
        }
    }

    private void launch() {
        log.info("Initialising Confluence Migration Plugin ..");
        this.pollingSetup.init();
        log.info("Confluence Migration Plugin initialised!");
    }

    private void registerListener() {
        log.info("Registering to event publisher to detect when plugin is enabled.");
        this.eventPublisher.register((Object)this);
    }

    private void unregisterListener() {
        log.info("Unregistering from event publisher to detect when plugin is enabled.");
        this.eventPublisher.unregister((Object)this);
    }

    static enum LifecycleEvent {
        AFTER_PROPERTIES_SET,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_ON_START;

    }
}

