/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationExecutor;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AbstractProcessor;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import org.slf4j.Logger;

public class AttachmentUploadProcessor
extends AbstractProcessor<AttachmentUploadTransferTask> {
    private final AttachmentMigrationExecutor attachmentMigrationExecutor;
    private final Step prcStep;
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentUploadProcessor.class);

    public AttachmentUploadProcessor(PrcTask<AttachmentUploadTransferTask> prcTask, Step prcStep, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, AttachmentMigrationExecutor attachmentMigrationExecutor) {
        super(prcTask, prcPoller, pollerConfigHandler);
        this.attachmentMigrationExecutor = attachmentMigrationExecutor;
        this.prcStep = prcStep;
    }

    @Override
    protected void process() {
        log.info("Processing V4 attachment upload. PrcStep id: {}", (Object)this.prcStep.getId());
        this.setProgressStartTime(this.prcStep, StepType.ATTACHMENT_UPLOAD);
        StepResult result = this.attachmentMigrationExecutor.runStepV4(this.prcStep.getId(), this.prcTask);
    }
}

