/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.prc;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.service.prc.PrcCommandExecutor;
import com.atlassian.migration.agent.service.prc.model.CommandName;
import com.atlassian.migration.prc.model.Command;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrcCommandExecutorCallback {
    private final ExecutorService commandExecutorService;
    private final ExecutorService migrationMetadataAggregatorCommandExecutorService;
    private final PrcCommandExecutor prcCommandExecutor;
    private final Logger log = LoggerFactory.getLogger(PrcCommandExecutorCallback.class);
    private int corePoolSize = 2;
    private int maxWorkerThreads = 2;
    private long keepAliveInSec = 60L;

    public PrcCommandExecutorCallback(PrcCommandExecutor prcCommandExecutor) {
        this.prcCommandExecutor = prcCommandExecutor;
        this.commandExecutorService = this.newCommandExecutorThreadPool();
        this.migrationMetadataAggregatorCommandExecutorService = Executors.newSingleThreadExecutor();
    }

    @VisibleForTesting
    public PrcCommandExecutorCallback(PrcCommandExecutor prcCommandExecutor, ExecutorService commandExecutorService, ExecutorService migrationMetadataAggregatorCommandExecutorService) {
        this.prcCommandExecutor = prcCommandExecutor;
        this.commandExecutorService = commandExecutorService;
        this.migrationMetadataAggregatorCommandExecutorService = migrationMetadataAggregatorCommandExecutorService;
    }

    @PreDestroy
    public void cleanup() {
        this.commandExecutorService.shutdown();
    }

    private ExecutorService newCommandExecutorThreadPool() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.corePoolSize, this.maxWorkerThreads, this.keepAliveInSec, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    @NotNull
    public Future<Void> execute(@NotNull Command command) {
        try {
            ExecutorService executorServiceForTaskType = this.getExecutorServiceForTaskType(command);
            return executorServiceForTaskType.submit(() -> {
                this.prcCommandExecutor.executeCommand(command);
                return null;
            });
        }
        catch (Exception e) {
            this.log.error("Error occurred while executing command {} with id: {} with message : {}", new Object[]{command.getName(), command.getId(), e.getMessage()});
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @VisibleForTesting
    protected ExecutorService getExecutorServiceForTaskType(Command command) {
        return this.isReplaceAllMetadataTask(command) ? this.migrationMetadataAggregatorCommandExecutorService : this.commandExecutorService;
    }

    private boolean isReplaceAllMetadataTask(Command command) {
        return command.getName().equals(CommandName.REPLACE_ALL_METADATA.getName());
    }
}

