/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.guardrails.macro.AbstractDatabaseMacroAssessmentSupplier;
import com.atlassian.migration.agent.service.guardrails.macro.BrokenNestedMacroSequences;
import com.atlassian.migration.agent.service.guardrails.macro.MacroSequenceSearch;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTuple;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class NestedMacroAssessmentSupplier
extends AbstractDatabaseMacroAssessmentSupplier {
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public NestedMacroAssessmentSupplier(EntityManagerTemplate tmpl, BootstrapManager bootstrapManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        super(tmpl, bootstrapManager);
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @Override
    String getQuery() {
        return "select cp.content.id as id, bc.body as body, c.spaceId as spaceId, c.container.id as pageId, c.type from ContentProperty cp join Content c on c.id = cp.content.id join BodyContent bc ON bc.contentId = c.id where c.previousVersion is null and cp.name = 'macroNames' and c.type in ('BLOGPOST', 'PAGE') and cp.stringval like '%,%' and (" + this.createMacroLikes() + ")";
    }

    @Override
    Stream<MacroTuple> map(Tuple tuple) {
        Long contentId = (Long)tuple.get(0, Long.class);
        String body = (String)tuple.get(1, String.class);
        Long spaceId = (Long)tuple.get(2, Long.class);
        Long pageId = (Long)tuple.get(3, Long.class);
        String contentType = (String)tuple.get(4, String.class);
        Elements elements = Jsoup.parse((String)body).select("ac|structured-macro");
        return elements.stream().filter(element -> !this.hasMacroParent((Element)element)).map((? super T element) -> new MacroTuple(contentId, spaceId, pageId, element.attr("ac:name"), contentType, this.getChildren((Element)element, 2))).filter(this.getBrokenSequenceFilter());
    }

    private Predicate<MacroTuple> getBrokenSequenceFilter() {
        return this.migrationDarkFeaturesManager.enableBrokenSequenceFilter() ? MacroSequenceSearch::containsBrokenTree : ignore -> true;
    }

    private List<MacroTuple.NestedMacroTuple> getChildren(Element macro, int level) {
        return macro.children().stream().flatMap(this::macros).map((? super T child) -> new MacroTuple.NestedMacroTuple(child.attr("ac:name"), level, this.getChildren((Element)child, level + 1))).collect(Collectors.toList());
    }

    private Stream<Element> macros(Element element) {
        return this.isMacro(element) ? Stream.of(element) : element.children().stream().flatMap(this::macros);
    }

    boolean hasMacroParent(Element element) {
        Element parent = element.parent();
        return parent != null && (this.isMacro(parent) || this.hasMacroParent(parent));
    }

    boolean isMacro(Element element) {
        return element.tagName().equalsIgnoreCase("ac:structured-macro");
    }

    @Override
    String getMacroAssessmentName() {
        return "Body content macro assessment";
    }

    private String createMacroLikes() {
        return BrokenNestedMacroSequences.getRootMacros().stream().map((? super T macro) -> "cp.stringval like '%" + macro + "%'").collect(Collectors.joining(" or "));
    }

    static class Macro {
        private final String name;
        private final int level;
        private final Set<Macro> children;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Generated
        public Set<Macro> getChildren() {
            return this.children;
        }

        @Generated
        public Macro(String name, int level, Set<Macro> children) {
            this.name = name;
            this.level = level;
            this.children = children;
        }
    }
}

