/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.migration.agent.service.featureflag.Fx3ClientFactory;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class Fx3Helper {
    private final Fx3ClientFactory fx3ClientFactory;
    private final FeatureFlagClient featureFlagClient;
    private final MigrationPlatformService migrationService;
    private static final String MIGRATION_TYPE = "MigrationType";
    private static final String SPACE_COUNT = "SpaceCount";
    private static final String CLOUD_ID = "CloudId";
    private static final String REGION = "Region";
    private static final String CLOUD_TYPE = "CloudType";

    @Inject
    public Fx3Helper(Fx3ClientFactory fx3ClientFactory, FeatureFlagClient featureFlagClient, MigrationPlatformService migrationService) {
        this.fx3ClientFactory = fx3ClientFactory;
        this.featureFlagClient = featureFlagClient;
        this.migrationService = migrationService;
    }

    public void updateUserCustomAttributes(Plan plan) {
        Map<String, Object> fx3UserCustomAttributesMap = this.fx3ClientFactory.createCustomAttributesMap();
        this.populatePlanCustomAttributes(fx3UserCustomAttributesMap, plan);
        this.featureFlagClient.updateCustomAttributes(fx3UserCustomAttributesMap);
    }

    private void populatePlanCustomAttributes(Map<String, Object> fx3UserCustomAttributesMap, Plan plan) {
        fx3UserCustomAttributesMap.put(MIGRATION_TYPE, this.evaluateMigrationType(plan));
        fx3UserCustomAttributesMap.put(SPACE_COUNT, this.getSpacesCount(plan));
        fx3UserCustomAttributesMap.put(CLOUD_ID, plan.getCloudSite().getCloudId());
        fx3UserCustomAttributesMap.put(REGION, this.migrationService.getConfluenceShardDetails(plan.getCloudSite().getContainerToken()).getShardInfo().get("region"));
        fx3UserCustomAttributesMap.put(CLOUD_TYPE, (Object)plan.getCloudSite().getCloudType());
    }

    private Integer getSpacesCount(Plan plan) {
        return plan.getTasks().stream().filter(task -> task.getType().equals((Object)TaskType.SPACE) || task.getType().equals((Object)TaskType.ATTACHMENTS)).collect(Collectors.toSet()).size();
    }

    private String evaluateMigrationType(Plan plan) {
        List<Task> tasks = plan.getTasks();
        if (this.isSpaceAttachmentsOnlyTasks(tasks)) {
            return TaskType.ATTACHMENTS.name();
        }
        if (this.isUsersAndGroupsOnlyTasks(tasks)) {
            return TaskType.USERS.name();
        }
        if (this.isGlobalEntitiesOnlyTasks(tasks)) {
            return TaskType.GLOBAL_ENTITIES.name();
        }
        if (this.isAppsOnlyTasks(tasks)) {
            return TaskType.APPS.name();
        }
        return TaskType.SPACE.name();
    }

    private boolean isSpaceAttachmentsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.ATTACHMENTS));
    }

    private boolean isUsersAndGroupsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.USERS));
    }

    private boolean isGlobalEntitiesOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.GLOBAL_ENTITIES));
    }

    private boolean isAppsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.APPS));
    }
}

