/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.model.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codehaus.jackson.annotate.JsonCreator;

@ParametersAreNonnullByDefault
public final class InstanceStats {
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final String version;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final String buildNumber;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final int numberOfUsers;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final int numberOfGroups;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final int numberOfSpaces;

    @JsonCreator
    @com.fasterxml.jackson.annotation.JsonCreator
    private InstanceStats(@org.codehaus.jackson.annotate.JsonProperty(value="version") @JsonProperty(value="version") String version, @org.codehaus.jackson.annotate.JsonProperty(value="buildNumber") @JsonProperty(value="buildNumber") String buildNumber, @org.codehaus.jackson.annotate.JsonProperty(value="numberOfUsers") @JsonProperty(value="numberOfUsers") int numberOfUsers, @org.codehaus.jackson.annotate.JsonProperty(value="numberOfGroups") @JsonProperty(value="numberOfGroups") int numberOfGroups, @org.codehaus.jackson.annotate.JsonProperty(value="numberOfSpaces") @JsonProperty(value="numberOfSpaces") int numberOfSpaces) {
        this.version = version;
        this.buildNumber = buildNumber;
        this.numberOfUsers = numberOfUsers;
        this.numberOfGroups = numberOfGroups;
        this.numberOfSpaces = numberOfSpaces;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public int getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public int getNumberOfSpaces() {
        return this.numberOfSpaces;
    }

    public static final class Builder {
        private String version;
        private String buildNumber;
        private int numberOfUsers;
        private int numberOfGroups;
        private int numberOfSpaces;

        private Builder() {
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder buildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        @Nonnull
        public Builder numberOfUsers(int numberOfUsers) {
            this.numberOfUsers = numberOfUsers;
            return this;
        }

        @Nonnull
        public Builder numberOfGroups(int numberOfGroups) {
            this.numberOfGroups = numberOfGroups;
            return this;
        }

        @Nonnull
        public Builder numberOfSpaces(int numberOfSpaces) {
            this.numberOfSpaces = numberOfSpaces;
            return this;
        }

        @Nonnull
        public InstanceStats build() {
            return new InstanceStats(this.version, this.buildNumber, this.numberOfUsers, this.numberOfGroups, this.numberOfSpaces);
        }
    }
}

