/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.migration.agent.entity.SpaceAttachmentsOnlyTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.impl.SpaceStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AttachmentUploadProcessor;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class AttachmentUploadWorker
extends V4Worker<AttachmentUploadTransferTask> {
    @Autowired
    private final AttachmentMigrationExecutor attachmentMigrationExecutor;
    @Autowired
    private final SpaceStore spaceStore;
    private AttachmentUploadTransferTask task;

    public AttachmentUploadWorker(List<ProgressUnit> supportedUnits, AttachmentMigrationExecutor attachmentMigrationExecutor, SpaceStore spaceStore, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate);
        this.attachmentMigrationExecutor = attachmentMigrationExecutor;
        this.spaceStore = spaceStore;
        this.commandName = CommandName.CONFLUENCE_ATTACHMENT_UPLOAD;
    }

    @Override
    public void process(PrcTask<AttachmentUploadTransferTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        prcStep.setType(StepType.ATTACHMENT_UPLOAD.name());
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
        AttachmentUploadProcessor processor = new AttachmentUploadProcessor(prcTask, prcStep, prcPoller, pollerConfigHandler, this.attachmentMigrationExecutor);
        processor.initiate();
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<AttachmentUploadTransferTask> prcTask) {
        String spaceKey = this.spaceStore.getSpaceMetadataForIndividualSpace(Long.parseLong(prcTask.getTransferTask().getSpaceId())).getSpaceKey();
        return tasks.stream().filter(SpaceAttachmentsOnlyTask.class::isInstance).map(SpaceAttachmentsOnlyTask.class::cast).filter(task1 -> spaceKey.equals(task1.getSpaceKey())).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
        SpaceAttachmentsOnlyTask task = (SpaceAttachmentsOnlyTask)step.getTask();
        step.setConfig(task.getSpaceKey());
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.CONFLUENCE_ATTACHMENT_UPLOAD;
    }
}

