/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.user.UsersMigrationExecutor;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AbstractProcessor;
import com.atlassian.migration.agent.v4.tasks.UsersGroupsUploadTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;

public class UserUploadProcessor
extends AbstractProcessor<UsersGroupsUploadTask> {
    private final UsersMigrationExecutor usersMigrationExecutor;
    private final Step prcStep;
    private static final Logger log = ContextLoggerFactory.getLogger(UserUploadProcessor.class);

    public UserUploadProcessor(PrcTask<UsersGroupsUploadTask> prcTask, UsersMigrationExecutor usersMigrationExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, Step prcStep) {
        super(prcTask, prcPoller, pollerConfigHandler);
        this.usersMigrationExecutor = usersMigrationExecutor;
        this.prcStep = prcStep;
    }

    @VisibleForTesting
    UserUploadProcessor(PrcTask<UsersGroupsUploadTask> prcTask, UsersMigrationExecutor usersMigrationExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, ScheduledExecutorService heartbeatScheduler, Step prcStep) {
        super(prcTask, prcPoller, pollerConfigHandler, heartbeatScheduler);
        this.usersMigrationExecutor = usersMigrationExecutor;
        this.prcStep = prcStep;
    }

    @Override
    protected void process() {
        log.info("Processing V4 user upload. PrcStep id: {}", (Object)this.prcStep.getId());
        this.setProgressStartTime(this.prcStep, StepType.USERS_MIGRATION);
        this.usersMigrationExecutor.doExportUpload(this.prcStep.getId(), Optional.of(this.prcTask));
    }
}

