/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers.status.converter;

import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.TransferStatusResponse;
import com.atlassian.migration.agent.v4.pollers.status.converter.OperationKey;
import com.atlassian.migration.agent.v4.pollers.status.converter.TransferProgressConverter;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ContainerProgressConverter<T extends AbstractContainer> {
    private static final String WORKFLOW_ENDED_PREMATURELY = "Migration workflow completed prematurely";
    private static final String WORKFLOW_CANCELLED = "Migration was aborted";
    private static final String WORKFLOW_TIMED_OUT = "Migration timed out";
    private final Map<OperationKey, TransferProgressConverter<T>> orderedTransferProgressConvertor;

    public ContainerProgressConverter(Map<OperationKey, TransferProgressConverter<T>> orderedTransferProgressConvertor) {
        this.orderedTransferProgressConvertor = orderedTransferProgressConvertor;
    }

    public Progress convert(AbstractContainer abstractContainer, AbstractContainer.ContainerStatus adaptedContainerStatus, Progress existingTaskProgress) {
        AbstractContainer container = abstractContainer;
        if (CollectionUtils.isEmpty(container.getTransfers())) {
            if (adaptedContainerStatus.isUnsuccessful()) {
                String message = ContainerProgressConverter.getMessageBasedOnUnsuccessfulContainerStatus(adaptedContainerStatus);
                return adaptedContainerStatus == AbstractContainer.ContainerStatus.CANCELLED ? existingTaskProgress.copy().stopped() : existingTaskProgress.copy().failed(message);
            }
            return existingTaskProgress;
        }
        return this.convertBasedOnTransfers(container, adaptedContainerStatus, existingTaskProgress);
    }

    private Progress convertBasedOnTransfers(T container, AbstractContainer.ContainerStatus adaptedContainerStatus, Progress existingTaskProgress) {
        Map operationKeyToTransferResponseMap = ((AbstractContainer)container).getTransfers().stream().collect(Collectors.toMap(TransferStatusResponse::getOperationKey, Function.identity()));
        Map.Entry<OperationKey, TransferProgressConverter<T>> highestOrderedEntryPresent = null;
        int startPercent = 0;
        for (Map.Entry<OperationKey, TransferProgressConverter<T>> convertorEntry : this.orderedTransferProgressConvertor.entrySet()) {
            OperationKey currentOperationKey = convertorEntry.getKey();
            if (!operationKeyToTransferResponseMap.containsKey(currentOperationKey.name())) continue;
            TransferStatusResponse transferStatusResponse = (TransferStatusResponse)operationKeyToTransferResponseMap.get(currentOperationKey.name());
            if (AbstractContainer.ContainerStatus.READY.name().equals(transferStatusResponse.getStatus().name())) break;
            if (highestOrderedEntryPresent != null) {
                startPercent = ((TransferProgressConverter)highestOrderedEntryPresent.getValue()).getPercentEndFunction().apply(container);
            }
            highestOrderedEntryPresent = convertorEntry;
        }
        if (highestOrderedEntryPresent != null) {
            TransferProgressConverter convertor = (TransferProgressConverter)highestOrderedEntryPresent.getValue();
            TransferStatusResponse response = (TransferStatusResponse)operationKeyToTransferResponseMap.get(((OperationKey)((Object)highestOrderedEntryPresent.getKey())).name());
            return convertor.convert(startPercent, existingTaskProgress, response, container, adaptedContainerStatus);
        }
        return existingTaskProgress;
    }

    public static String getMessageBasedOnUnsuccessfulContainerStatus(AbstractContainer.ContainerStatus adaptedContainerStatus) {
        if (adaptedContainerStatus == AbstractContainer.ContainerStatus.CANCELLED) {
            return WORKFLOW_CANCELLED;
        }
        if (adaptedContainerStatus == AbstractContainer.ContainerStatus.TIMED_OUT) {
            return WORKFLOW_TIMED_OUT;
        }
        return WORKFLOW_ENDED_PREMATURELY;
    }
}

