/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers.status;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.fugue.Pair;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceSpaceContainer;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.InProgressMigration;
import com.atlassian.migration.agent.v4.migration.PlatformMigrationStatus;
import com.atlassian.migration.agent.v4.pollers.status.InProgressMigrationStatus;
import com.atlassian.migration.agent.v4.pollers.status.converter.ContainerProgressConverter;
import com.atlassian.migration.agent.v4.pollers.status.converter.ContainerProgressConverterFactory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class StatusRetreivalService {
    private PlanStore planStore;
    private TaskStore taskStore;
    private PlatformService platformService;
    private SpaceManager spaceManager;
    private PluginTransactionTemplate ptx;
    private static final Logger log = ContextLoggerFactory.getLogger(StatusRetreivalService.class);

    public StatusRetreivalService(PlanStore planStore, TaskStore taskStore, PlatformService platformService, SpaceManager spaceManager, PluginTransactionTemplate ptx) {
        this.planStore = planStore;
        this.taskStore = taskStore;
        this.platformService = platformService;
        this.spaceManager = spaceManager;
        this.ptx = ptx;
    }

    public InProgressMigrationStatus getAdaptedMigrationStatus(InProgressMigration inProgressMigration) {
        log.info("Retrieving status for plan from MCS: {}", (Object)inProgressMigration.getPlanId());
        Plan plan = this.ptx.read(() -> this.planStore.getPlanWithTasksEagerly(inProgressMigration.getPlanId()));
        ExecutionStatus previousStatus = plan.getProgress().getStatus();
        boolean statusRetrievalSuccessful = false;
        boolean tasksUpdated = false;
        ExecutionStatus newStatus = previousStatus;
        try {
            Pair<PlatformMigrationStatus, List<AbstractContainer>> containersStatus = this.platformService.getContainersWithTransfers(inProgressMigration.getCloudSite().getCloudId(), inProgressMigration.getMigrationId());
            PlatformMigrationStatus platformMigrationStatus = (PlatformMigrationStatus)((Object)containersStatus.left());
            List<Task> updatedTasks = this.getUpdatedTasks((List)containersStatus.right(), platformMigrationStatus, plan.getId());
            tasksUpdated = !updatedTasks.isEmpty();
            statusRetrievalSuccessful = true;
            newStatus = platformMigrationStatus.getExecutionStatus();
        }
        catch (Exception e) {
            log.error("Failed to retrieve status from platform", (Throwable)e);
        }
        return new InProgressMigrationStatus(previousStatus, newStatus, statusRetrievalSuccessful, tasksUpdated);
    }

    private List<Task> getUpdatedTasks(List<AbstractContainer> containers, PlatformMigrationStatus platformMigrationStatus, String planId) {
        return containers.stream().map(abstractContainer -> {
            AbstractContainer.ContainerStatus adaptedContainerStatus = (Objects.nonNull((Object)abstractContainer.getStatus()) ? abstractContainer.getStatus() : AbstractContainer.ContainerStatus.READY).adaptStatus(platformMigrationStatus);
            return this.getUpdatedTaskIfApplicable((AbstractContainer)abstractContainer, adaptedContainerStatus, planId);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Task> getUpdatedTaskIfApplicable(AbstractContainer abstractContainer, AbstractContainer.ContainerStatus adaptedContainerProgress, String planId) {
        return this.ptx.write(() -> {
            Task task;
            switch (abstractContainer.getType()) {
                case ConfluenceSpace: {
                    ConfluenceSpaceContainer confluenceSpaceContainer = (ConfluenceSpaceContainer)abstractContainer;
                    String spaceKey = this.spaceManager.getSpace(Long.parseLong(confluenceSpaceContainer.getSourceId())).getKey();
                    task = this.taskStore.findTaskByPlanIdAndSpaceKeyAndLock(planId, spaceKey).get();
                    break;
                }
                case Site: {
                    task = this.taskStore.findMigrateUsersTaskByPlanIdAndLock(planId).get();
                    break;
                }
                default: {
                    throw new RuntimeException("not supported task type: " + (Object)((Object)abstractContainer.getType()));
                }
            }
            ContainerProgressConverter<?> containerProgressConvertor = ContainerProgressConverterFactory.getContainerProgressConvertor(abstractContainer.getType());
            Progress existingTaskProgress = task.getProgress();
            Progress newTaskProgress = containerProgressConvertor.convert(abstractContainer, adaptedContainerProgress, existingTaskProgress);
            log.info("Computed New Progress. Updating the task progress on DB");
            if (!newTaskProgress.equals(existingTaskProgress)) {
                task.setProgress(newTaskProgress);
                if (task instanceof AbstractSpaceTask) {
                    ((AbstractSpaceTask)task).onPostPersistOrUpdate();
                }
                this.taskStore.update(task);
                return Optional.of(task);
            }
            return Optional.empty();
        });
    }
}

