/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.jpa.impl;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import java.util.stream.Stream;
import org.hibernate.HibernateException;
import org.hibernate.StatelessSession;
import org.hibernate.query.Query;
import org.slf4j.Logger;

public class StatelessResults<T>
implements AutoCloseable {
    private final StatelessSession statelessSession;
    private final Query<T> query;
    private static final Logger log = ContextLoggerFactory.getLogger(StatelessResults.class);

    public StatelessResults(StatelessSession statelessSession, Query<T> query) {
        this.statelessSession = statelessSession;
        this.query = query;
    }

    public Stream<T> stream() {
        return this.query.stream();
    }

    @Override
    public void close() {
        try {
            this.statelessSession.close();
        }
        catch (HibernateException e) {
            log.error("Error while closing hibernate connection", (Throwable)e);
        }
    }
}

