/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.migration.agent.v4.InProgressMigrationIds;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.pollers.AbstractPoller;
import com.atlassian.migration.agent.v4.pollers.PollerConfig;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.Command;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V4Poller<T extends TransferTask>
extends AbstractPoller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V4Poller.class);
    private V4Worker<T> worker;
    private PollerConfig config;
    private OnDemandPrcPoller prcPoller;
    private InProgressMigrationIds migrationIds;

    public V4Poller(String pollerId, V4Worker<T> worker, PollerConfig config, OnDemandPrcPoller prcPoller, InProgressMigrationIds inProgressMigrationIds) {
        super(pollerId, config.getPollingDelay());
        this.worker = worker;
        this.config = config;
        this.prcPoller = prcPoller;
        this.migrationIds = inProgressMigrationIds;
    }

    @Override
    public boolean doPoll() {
        return this.migrationIds.sequence().filter(m -> MigrationProtocol.V4.equals((Object)m.getProtocol())).map(m -> this.pollForTaskAndDispatch(m.getCloudId())).anyMatch(isSuccess -> isSuccess);
    }

    private boolean pollForTaskAndDispatch(String cloudId) {
        try {
            log.debug("Polling command for poller: $pollerId");
            Command command = new Command(123L, "TEST_NAME", "TEST_PAYLOAD");
            log.debug("Command: {} received for poller {}", (Object)command.getId(), (Object)this.pollerId);
            this.dispatchTask(cloudId, command);
        }
        catch (Exception e) {
            log.warn("Poller {} failed with exception {}, will try again", (Object)this.pollerId, (Object)e);
        }
        return true;
    }

    private PrcTask toPrcTask(Command command) {
        log.info("TODO convert the command {} to PRCTask", (Object)command.getId());
        return new PrcTask();
    }

    private boolean dispatchTask(String cloudId, Command command) {
        PrcTask task = this.toPrcTask(command);
        try {
            this.worker.process(task);
            return true;
        }
        catch (Exception e) {
            log.error("{}: task worker failed to process {}", (Object)this.worker.getId(), (Object)e);
            log.error("Marking task as failed in PRC");
            this.reportFailureToPRC(cloudId, task, e);
            return false;
        }
    }

    private void reportFailureToPRC(String cloudId, PrcTask task, Throwable e) {
        try {
            log.info(" TODO update failure result to PRC for the {}", (Object)cloudId);
        }
        catch (RuntimeException r) {
            log.error("${}: failed to update task status in PRC for command: {} {} {} ", new Object[]{this.worker.getId(), task.getPrcCommandId(), r, e});
        }
    }
}

