/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.CorrectedEmail;
import com.atlassian.migration.agent.service.email.EmailCheckType;
import com.atlassian.migration.agent.store.CorrectedEmailStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.QueryBuilder;
import com.atlassian.migration.udc.common.model.repository.DbResult;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class CorrectedEmailStoreImpl
implements CorrectedEmailStore {
    private final EntityManagerTemplate tmpl;

    @Override
    public long setDraftDataToConfirmed(UDCMode udcMode) {
        String updateJpql = "update CorrectedEmail ce set ce.draft=false where ce.draft=true and ce.udcMode=:udcMode";
        return this.tmpl.query(updateJpql).param("udcMode", (Object)udcMode).update();
    }

    @Override
    public long deleteByDraftMode(UDCMode udcMode, Boolean draft) {
        String jpql = "delete from CorrectedEmail ce where ce.udcMode=:udcMode and ce.draft=:draft";
        return this.tmpl.query("delete from CorrectedEmail ce where ce.udcMode=:udcMode and ce.draft=:draft").param("udcMode", (Object)udcMode).param("draft", (Object)draft).update();
    }

    @Override
    public long countByCheckType(EmailCheckType type, UDCMode udcMode, Boolean draft) {
        String jpql = "select count(ce) from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode and ce.draft=:draft";
        return this.tmpl.query(Long.class, "select count(ce) from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode and ce.draft=:draft").param("type", (Object)type).param("udcMode", (Object)udcMode).param("draft", (Object)draft).single();
    }

    @Override
    public long deleteByEmailCheckType(EmailCheckType type, UDCMode udcMode) {
        String jpql = "delete from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode";
        return this.tmpl.query("delete from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode").param("type", (Object)type).param("udcMode", (Object)udcMode).update();
    }

    @Override
    public long deleteByUdcMode(UDCMode udcMode) {
        String jpql = "delete from CorrectedEmail ce where ce.udcMode=:udcMode";
        return this.tmpl.query("delete from CorrectedEmail ce where ce.udcMode=:udcMode").param("udcMode", (Object)udcMode).update();
    }

    @Override
    public List<CorrectedEmail> fetchAll(UDCMode udcMode, Boolean draft) {
        String jpql = "select ce from CorrectedEmail ce where ce.udcMode=:udcMode and ce.draft=:draft";
        return this.tmpl.query(CorrectedEmail.class, "select ce from CorrectedEmail ce where ce.udcMode=:udcMode and ce.draft=:draft").param("udcMode", (Object)udcMode).param("draft", (Object)draft).list();
    }

    @Override
    public List<CorrectedEmail> fetchByEmailCheckType(@Nullable EmailCheckType type, UDCMode udcMode, Boolean draft) {
        String jpql = "select ce from CorrectedEmail ce where ce.udcMode=:udcMode and ce.draft=:draft and ce.type" + (type != null ? "=:type" : " is NULL");
        QueryBuilder<CorrectedEmail> query = this.tmpl.query(CorrectedEmail.class, jpql).param("udcMode", (Object)udcMode).param("draft", (Object)draft);
        if (type != null) {
            query.param("type", (Object)type);
        }
        return query.list();
    }

    @Override
    public List<String> findUserKeysByType(EmailCheckType type, UDCMode udcMode, Boolean draft) {
        String jpql = "select ce.userKey from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode and ce.draft=:draft";
        return this.tmpl.query(String.class, "select ce.userKey from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode and ce.draft=:draft").param("type", (Object)type).param("udcMode", (Object)udcMode).param("draft", (Object)draft).list();
    }

    @Override
    public DbResult insert(List<CorrectedEmail> correctedEmails, String userKey) {
        try {
            correctedEmails.forEach(this.tmpl::persist);
            return new DbResult.Success.Inserted("Inserted " + correctedEmails.size() + " corrected emails.");
        }
        catch (Exception e) {
            return new DbResult.Failed("Failed to insert corrected emails: " + e.getMessage());
        }
    }

    @Override
    public Boolean isAnyRecordFound(UDCMode udcMode, Boolean draft) {
        String jpql = "select ce.id from CorrectedEmail ce where ce.udcMode=:udcMode and ce.draft=:draft";
        return this.tmpl.query(String.class, "select ce.id from CorrectedEmail ce where ce.udcMode=:udcMode and ce.draft=:draft").param("udcMode", (Object)udcMode).param("draft", (Object)draft).first().isPresent();
    }

    @Override
    public Boolean isRecordFoundForEmailCheckType(EmailCheckType checkType, UDCMode udcMode, Boolean draft) {
        String jpql = "select ce.id from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode and ce.draft=:draft";
        return this.tmpl.query(String.class, "select ce.id from CorrectedEmail ce where ce.type=:type and ce.udcMode=:udcMode and ce.draft=:draft").param("type", (Object)checkType).param("udcMode", (Object)udcMode).param("draft", (Object)draft).first().isPresent();
    }

    @Generated
    public CorrectedEmailStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }
}

