/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.queries.GuardrailsQueries;
import com.atlassian.migration.agent.store.guardrails.queries.ListQuery;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Tuple;

public class PageDepthQuery
extends ListQuery {
    private static final int LIMIT = 100;
    private static final int PAGE_DEPTH_CUTOFF = 200;
    private final DbType dbType;

    public PageDepthQuery(EntityManagerTemplate tmpl, DbType dbType) {
        super(QueryIds.PAGE_TREE_DEPTH, tmpl, GuardrailsQueries.PAGE_DEPTH_QUERY.query(dbType), true, AbstractQuery.QueryBuilderOptions.max(100), PageDepthQuery.example("space_id", "max_depth").addRow(100L, 15).addRow(115L, 8));
        this.dbType = dbType;
    }

    @Override
    public ListResult execute() {
        if (DbType.MYSQL == this.dbType) {
            return new ListResult(this.findPageDepthPerSpace(), 100);
        }
        return super.execute();
    }

    private List<Tuple> findPageDepthPerSpace() {
        List<Tuple> result = this.createNativeQuery(Tuple.class, "select CONTENTID FROM CONTENT WHERE PARENTID is NULL and CONTENT_STATUS = 'current' and PREVVER is NULL and CONTENTTYPE = 'PAGE';").list();
        HashMap<Number, Integer> maxSpaceDepth = new HashMap<Number, Integer>();
        for (int depth = 1; depth <= 200 && !result.isEmpty(); ++depth) {
            result = this.createNativeQuery(Tuple.class, GuardrailsQueries.pageDepthChildPageQuery(result)).list();
            for (Tuple t : result) {
                maxSpaceDepth.put((Number)t.get(1, Number.class), depth);
            }
        }
        return maxSpaceDepth.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(100L).map(e -> GuardrailsUtil.getTuple((Map<String, Object>)ImmutableMap.of((Object)"space_id", e.getKey(), (Object)"max_depth", e.getValue()))).collect(Collectors.toList());
    }
}

