/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.migration.agent.service.guardrails.macro.BrokenNestedMacroSequences;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTree;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTuple;
import java.util.List;
import java.util.Set;

class MacroSequenceSearch {
    private MacroSequenceSearch() {
        throw new IllegalStateException("Utility class");
    }

    static boolean containsBrokenTree(MacroTuple macroTuple, Set<String[]> brokenMacroSequence) {
        return brokenMacroSequence.stream().anyMatch(seq -> MacroSequenceSearch.dfs(macroTuple, seq, 0));
    }

    static boolean containsBrokenTree(MacroTuple macroTuple) {
        return MacroSequenceSearch.containsBrokenTree(macroTuple, BrokenNestedMacroSequences.NESTED_MACRO_SEQUENCES);
    }

    private static boolean dfs(MacroTree tree, String[] sequence, int idx) {
        return tree.getMacro().equals(sequence[idx]) && MacroSequenceSearch.dfs(tree.getChildren(), sequence, idx + 1) || idx == 0 && MacroSequenceSearch.dfs(tree.getChildren(), sequence, 0);
    }

    private static boolean dfs(List<MacroTuple.NestedMacroTuple> tuples, String[] sequence, int idx) {
        return idx == sequence.length || tuples.stream().anyMatch(tuple -> MacroSequenceSearch.dfs(tuple, sequence, idx));
    }
}

