/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.entity.NodeInfrastructureInfo;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;

public class InfrastructureAssessmentStore {
    private static final String ASSESSMENT_FILE_NAME = "confluence-instance-metadata-%s.jsonl";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final BootstrapManager bootstrapManager;
    private final EntityManagerTemplate tmpl;

    public Path getInstanceAssessmentPath(LocalDate date, InstanceAssessmentResult result) throws IOException {
        String assessmentFileName = String.format(ASSESSMENT_FILE_NAME, DATE_FORMATTER.format(date));
        Path jsonFilePath = Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), assessmentFileName);
        SerializationUtil.saveJson(jsonFilePath.toFile(), result);
        return Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), assessmentFileName);
    }

    public void saveNodeInfoItem(NodeInfrastructureInfo nodeInfrastructureInfo) {
        NodeInfrastructureInfo existingNodeInfrastructureInfo = this.findNodeInfoById(nodeInfrastructureInfo.getId());
        if (existingNodeInfrastructureInfo == null) {
            this.tmpl.persist(nodeInfrastructureInfo);
        } else {
            this.tmpl.merge(nodeInfrastructureInfo);
        }
    }

    public NodeInfrastructureInfo findNodeInfoById(String id) {
        return this.tmpl.query(NodeInfrastructureInfo.class, "SELECT n FROM NodeInfrastructureInfo n WHERE n.id = :id").param("id", (Object)id).singleOrNull();
    }

    public List<NodeInfrastructureInfo> findAllNodeInfo() {
        return this.tmpl.query(NodeInfrastructureInfo.class, "from NodeInfrastructureInfo").list();
    }

    @Generated
    public InfrastructureAssessmentStore(BootstrapManager bootstrapManager, EntityManagerTemplate tmpl) {
        this.bootstrapManager = bootstrapManager;
        this.tmpl = tmpl;
    }
}

