/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics;

import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnalyticsEventConstants {
    public static final Set<DirectoryType> LDAP_DIRECTORY_TYPES = EnumSet.of(DirectoryType.CONNECTOR, DirectoryType.DELEGATING, DirectoryType.CUSTOM);
    public static final String CONTAINER_TYPE_KEY = "containerType";
    public static final String CONFLUENCE_SPACE = "CONFLUENCE_SPACE";
    public static final String GLOBAL_ENTITIES = "GLOBAL_ENTITIES";
    public static final String COMPONENT_KEY = "component";
    public static final String PHASE_KEY = "phase";
    public static final String OPERATION_KEY = "operationKey";
    public static final String SPACE_COMPONENT = "Space";
    public static final String GLOBAL_ENTITIES_COMPONENT = "GlobalEntities";
    public static final String IMPORT = "Import";
    public static final String EXPORT = "Export";
    public static final Set<String> KEYS = new HashSet<String>(Arrays.asList("containerType", "component", "phase", "operationKey"));
    public static final Map<String, String> mediaUploadEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"CONFLUENCE_SPACE", (Object)"component", (Object)"Media", (Object)"phase", (Object)"Upload", (Object)"operationKey", (Object)"confluenceAttachmentUpload");
    public static final Map<String, String> spaceImportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"CONFLUENCE_SPACE", (Object)"component", (Object)"Space", (Object)"phase", (Object)"Import", (Object)"operationKey", (Object)"confluenceImport");
    public static final Map<String, String> spaceExportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"CONFLUENCE_SPACE", (Object)"component", (Object)"Space", (Object)"phase", (Object)"Export", (Object)"operationKey", (Object)"confluenceSpaceUpload");
    public static final Map<String, String> userImportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"SITE", (Object)"component", (Object)"User", (Object)"phase", (Object)"Import", (Object)"operationKey", (Object)"allUserImport");
    public static final Map<String, String> userExportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"SITE", (Object)"component", (Object)"User", (Object)"phase", (Object)"Export", (Object)"operationKey", (Object)"allUserExport");
    public static final Map<String, String> globalEntitiesExportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"GLOBAL_ENTITIES", (Object)"component", (Object)"GlobalEntities", (Object)"phase", (Object)"Export", (Object)"operationKey", (Object)"globalEntitiesUpload");
    public static final Map<String, String> globalEntitiesImportEventAttributesMap = ImmutableMap.of((Object)"containerType", (Object)"GLOBAL_ENTITIES", (Object)"component", (Object)"GlobalEntities", (Object)"phase", (Object)"Import", (Object)"operationKey", (Object)"globalEntitiesImport");
    public static final String STOPPED = "stopped";
    public static final String RESULT = "result";
    public static final String SUCCESS = "success";
    public static final String FAIL = "fail";
    public static final String PRODUCT = "product";
    public static final String VERSION = "version";
    public static final String IS_INTERNAL_SEN = "isInternalSen";
    public static final String PLUGIN_VERSION = "pluginVersion";
    public static final String IS_INTERNAL_CONTEXT = "isInternalContext";
    public static final String REASON = "reason";
    public static final String CONFIGURED_HEAP_SIZE = "configuredHeapSize";
    public static final String FREE_HEAP_SIZE = "freeHeapSize";
    public static final String FREE_HEAP_SIZE_AT_START = "freeHeapSizeAtStart";
    public static final String USED_HEAP_SIZE = "usedHeapSize";
    public static final String ESTIMATED_TIME = "estimatedTime";
    public static final String TOTAL_ATTACHMENTS_SIZE = "totalAttachmentsSize";
    public static final String STATUS = "status";
    public static final String EXECUTED = "executed";
    public static final String UDC2 = "user-data-compatibility-plugin-2";
    public static final String USER_BASE_SCAN = "userBaseScan";
    public static final String NEW_EMAIL_SUGGESTING = "newEmailSuggesting";
    public static final String NUMBER_OF_SPACES = "numberOfSpaces";
    public static final String MIGRATION = "migration";
    public static final String MIGRATION_ID = "migrationId";
    public static final String MIGRATION_TAG = "migrationTag";
    public static final String MIGRATION_CREATOR = "migrationCreator";
    public static final String TENANT_ID = "tenantId";
    public static final String TIME_TAKEN = "timeTaken";
    public static final String SPACE_EXPORT_TYPE = "spaceExportType";
    public static final String SPACE_IMPORT_TYPE = "spaceImportType";
    public static final String SPACE_EXPORT_ACTION_NAME = "exportedAndPostProcessed";
    public static final String ATTACHMENT_UPLOAD_ACTION_NAME = "attachmentsUploaded";
    public static final String LOGGED_ACTION_NAME = "logged";
    public static final String SPACE_IMPORTED_ACTION_NAME = "spaceImported";
    public static final String EXPORT_POST_PROCESSED_ACTION_NAME = "postProcessed";
    public static final String SPACE_UPLOADED_ACTION_NAME = "spaceUploaded";
    public static final String GLOBAL_ENTITIES_EXPORT_ACTION_NAME = "globalEntitiesExported";
    public static final String GLOBAL_ENTITIES_CSV_EXPORT_ACTION_NAME = "globalEntitiesCSVExported";
    public static final String GLOBAL_ENTITIES_IMPORT_ACTION_NAME = "globalEntitiesImported";
    public static final String GLOBAL_ENTITIES_UPLOAD_ACTION_NAME = "globalEntitiesUploaded";
    public static final String MCS_FILE_UPLOADED_ACTION_NAME = "fileUploadedToMCS";
    public static final String CLOUD_TYPE_SETTINGS_ACTION_NAME = "cloudTypeSettingsUpdated";
    public static final String MCS_GLOBAL_ENTITIES_FILE_UPLOADED_ACTION_NAME = "globalEntitiesFileUploadedToMCS";
    public static final String TABLE_EXPORTED_TO_CSV_ACTION_NAME = "tableExportedToCSV";
    public static final String MAPI_JOB_ACTION_SUBJECT = "mapiJob";
    public static final String FEATURE_FLAG_ACTION_ITEM = "featureFlag";
    public static final String UPLOAD_SIZE_ATTRIBUTE_NAME = "uploadSize";
    public static final String UPLOAD_TYPE_ATTRIBUTE_NAME = "uploadDestinationType";
    public static final String FILE_NAME_ATTRIBUTE_NAME = "fileName";
    public static final String TABLE_NAME_ATTRIBUTE_NAME = "tableName";
    public static final String TIME_TO_FIRST_RECORD_ATTRIBUTE_NAME = "timeToFirstRecord";
    public static final String ROWS_EXPORTED_ATTRIBUTE_NAME = "rowsExported";
    public static final String CHARS_EXPORTED_ATTRIBUTE_NAME = "charactersExported";
    public static final String EXPORT_QUERY_HASH_ATTRIBUTE_NAME = "exportQueryHash";
    public static final String ERROR_CODE_ATTRIBUTE_NAME = "errorCode";
    public static final String TYPE_ATTRIBUTE_NAME = "type";
    public static final String SPACE_UPLOAD_TYPE = "spaceUploadType";
    public static final String DB_TYPE = "dbType";
    public static final String OBJECT_FAILURE_SUBJECT_NAME = "objectFailure";
    public static final String SKIPPED_STEP_SUBJECT_NAME = "skippedStep";
    public static final String FEATURE_FLAG_ATTRIBUTE_NAME = "featureFlagKey";
    public static final String KNOWN_SOURCE = "knownSource";
    public static final String NUMBER_OF_USERS = "numberOfUsers";
    public static final String NUMBER_OF_PAGES = "numberOfPages";
    public static final String NUMBER_OF_BLOGS = "numberOfBlogs";
    public static final String NUMBER_OF_TEAM_CALENDARS = "numberOfTeamCalendars";
    public static final String NUMBER_OF_GROUPS = "numberOfGroups";
    public static final String MAPI_JOB_ID = "mapiJobId";
    public static final String PLAN_ID = "planId";
    public static final String SPACE_ID = "spaceId";
    public static final String TC_EXPORT_TIME = "tcExportTime";
    public static final String NODE_ID = "nodeId";
    public static final String NODE_EXECUTION_ID = "nodeExecutionId";
    public static final String EXECUTION_STATE = "executionState";
    public static final String NODE_HEARTBEAT = "nodeHeartBeat";
    public static final String OLD_STEP_ALLOCATION_NODE_ID = "oldStepAllocationNodeId";
    public static final String OLD_STEP_ALLOCATION_NODE_EXECUTION_ID = "oldStepAllocationNodeExecutionId";
    public static final String USER_DOMAIN_RULE = "userDomainRule";
    public static final String REVIEW_SCREEN = "reviewScreen";
    public static final String UNKNOWN = "Unknown";
    public static final String IMPORT_TASK_ID = "importTaskId";
    public static final String STATUS_CODE = "statusCode";
    public static final String SCAN_ID = "scanId";
    public static final String TASK_ID = "taskId";
    public static final String START_TIME = "startTime";
    public static final String STOP_TIME = "stopTime";
    public static final String EXPORT_TYPE = "exportType";
    public static final String FILE_ID = "fileId";
    public static final String STEP_TYPE = "stepType";
    public static final String STEP_ID = "stepId";
    public static final String TASK_TYPE = "taskType";
    public static final String CONFLUENCE = "confluence";
    public static final String CONFLUENCE_PRODUCT_FAMILY = "CONFLUENCE";
    public static final String MIGRATION_TYPE = "migrationType";
    public static final String PRODUCT_FAMILY = "productFamily";
    public static final String S2C_MIGRATION = "S2C_MIGRATION";
    public static final String CREATED = "created";
    public static final String STARTED = "started";
    public static final String COMPLETED = "completed";
    public static final String FAILED = "failed";
    public static final String FINISHED = "finished";
    public static final String STEP = "step";
    public static final String PLAN = "plan";
    public static final String SPACE = "space";
    public static final String GLOBAL_ENTITY = "globalEntity";
    public static final String PLATFORM_EVENT = "platformEvent";
    public static final String NETWORK_HEALTH_CHECK_EVENT = "networkHealthCheck";
    public static final String NETWORK_HEALTH_PRE_MIGRATION_CHECK_EVENT = "networkHealthPreMigrationCheck";
    public static final String RELATIONS_ANALYSER = "relationsAnalyser";
    public static final String RELATIONS_ANALYSIS_JOB = "relationsAnalysisJob";
    public static final String USER_EXPORT = "USER_EXPORT";
    public static final String ADDED = "added";
    public static final String OBJECT = "object";
    public static final String UPDATED = "updated";
    public static final String REPLACED = "replaced";
    public static final String BATCH_SIZE = "batchSize";
    public static final String CONFLUENCE_VERSION = "confluenceVersion";
    public static final String DATABASE = "database";
    public static final String SERVER_ID = "serverId";
    public static final String JOB_ID = "jobId";
    public static final String INCLUDE_HISTORICAL_DATA = "includeHistoricalData";
    public static final String ERROR = "error";
    public static final String INTERNAL_SEN = "SEN-500";
    public static final String EXECUTOR_CONCURRENCY_CLUSTER = "executorConcurrencyCluster";
    public static final String EXECUTOR_CONCURRENCY_NODE = "executorConcurrencyNode";
    public static final String SPACE_STATISTIC_CALCULATION = "spaceStatisticCalculation";
    public static final String ENCRYPTION_KEY_LOCATION = "encryptionKeyLocation";
    public static final String TOKEN_ENCRYPTION_ACTION_NAME = "tokenEncryption";
    public static final String CHECK_SCREEN = "checkScreen";
    public static final String NUMBER_OF_FAILED_DOMAINS = "numberOfFailedDomains";
    public static final String FAILED_DOMAINS_BY_SERVICE_NAME = "failedDomainsByServiceName";
    public static final String NUMBER_OF_APPS = "numberOfApps";
    public static final String NUMBER_OF_TEMPLATES = "numberOfTemplates";
    public static final String TC_APP_VERSION = "tcAppVersion";
    public static final String EDITION = "edition";
    public static final String CLOUD_PREMIUM_EDITION_CHECK_EVENT = "cloudPremiumEditionCheck";
    public static final String STEP_SUCCESSFUL = "stepSuccessful";
    public static final Map<String, Map<String, String>> stepCompletionEventAttributesMap = AnalyticsEventConstants.populateStepCompletionEventAttributesMap();
    public static final String METADATA_EVENT_SOURCE = "CCMA";

    private AnalyticsEventConstants() {
        throw new IllegalStateException("Constants class");
    }

    public static Map<String, Map<String, String>> populateStepCompletionEventAttributesMap() {
        HashMap<String, Map<String, String>> stepCompletionEventAttributesMap = new HashMap<String, Map<String, String>>();
        stepCompletionEventAttributesMap.put(StepType.ATTACHMENT_UPLOAD.name(), mediaUploadEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.DATA_UPLOAD.name(), spaceExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.CONFLUENCE_IMPORT.name(), spaceImportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.SPACE_USERS_MIGRATION.name(), spaceExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.CONFLUENCE_EXPORT.name(), spaceExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.USERS_MIGRATION.name(), userImportEventAttributesMap);
        stepCompletionEventAttributesMap.put(USER_EXPORT, userExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.GLOBAL_ENTITIES_EXPORT.name(), globalEntitiesExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.GLOBAL_ENTITIES_DATA_UPLOAD.name(), globalEntitiesExportEventAttributesMap);
        stepCompletionEventAttributesMap.put(StepType.GLOBAL_ENTITIES_IMPORT.name(), globalEntitiesImportEventAttributesMap);
        return stepCompletionEventAttributesMap;
    }
}

