/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.migration.agent.v4.migration.ThreadUtils;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPoller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPoller.class);
    protected String pollerId;
    private Duration pollingDelay;
    private AtomicReference<PollerState> currentState = new AtomicReference<PollerState>(PollerState.STOPPED);

    protected AbstractPoller(String pollerId, Duration pollingDelay) {
        this.pollerId = pollerId;
        this.pollingDelay = pollingDelay;
    }

    public String getPollerId() {
        return this.pollerId;
    }

    public void startPolling() {
        while (this.isStopping()) {
            log.info("{}: Wait for previous shutdown", (Object)this.pollerId);
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.currentState.compareAndSet(PollerState.STOPPED, PollerState.RUNNING)) {
            ThreadUtils.safeExecutePeriodicallyUntilStopped(this::execute, this.pollingDelay, this.shouldSkipDelayIfWorkExecuted(), this::isPolling);
            this.currentState.set(PollerState.STOPPED);
        }
    }

    private boolean execute() {
        return this.doPoll();
    }

    protected abstract boolean doPoll();

    protected boolean shouldSkipDelayIfWorkExecuted() {
        return true;
    }

    public void stopPolling() {
        this.currentState.compareAndSet(PollerState.RUNNING, PollerState.STOPPING);
    }

    private boolean isStopping() {
        return this.currentState.get() == PollerState.STOPPING;
    }

    private boolean isPolling() {
        return this.currentState.get() == PollerState.RUNNING;
    }

    public static enum PollerState {
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

