/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.migration.agent.entity.ExportType;
import com.atlassian.migration.agent.entity.ImportType;
import com.atlassian.migration.agent.entity.UploadDestinationType;
import com.atlassian.migration.agent.service.analytics.AnalyticsMessageHandler;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class ErrorAndLoggingAnalyticsEventBuilder {
    private final PluginVersionManager pluginVersionManager;
    private final SystemInformationService systemInformationService;
    private SENSupplier senSupplier;
    private Supplier<Instant> instantSupplier;
    private AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public ErrorAndLoggingAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(pluginVersionManager, systemInformationService, senSupplier, Instant::now, analyticsEventBuilderUtil);
    }

    @VisibleForTesting
    ErrorAndLoggingAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, SENSupplier senSupplier, Supplier<Instant> instantSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.pluginVersionManager = pluginVersionManager;
        this.systemInformationService = systemInformationService;
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildMigrationLogTimerEvent(boolean success, long totalTime, String action, String migrationId) {
        return this.buildMigrationLogTimerEvent(success, totalTime, action, migrationId, null, Optional.empty(), Optional.empty());
    }

    public EventDto buildMigrationLogTimerEvent(boolean success, long totalTime, String action, String migrationId, Optional<String> errorReason) {
        return this.buildMigrationLogTimerEvent(success, totalTime, action, migrationId, null, errorReason, Optional.empty());
    }

    public EventDto buildMigrationLogTimerEvent(boolean success, long totalTime, String action, String migrationId, String cloudId, Optional<String> reason, Optional<String> fileName) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"timeTaken", (Object)Long.toString(totalTime));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        if (StringUtils.isNotEmpty((String)cloudId)) {
            attributes.put((Object)"tenantId", (Object)cloudId);
        }
        if (reason.isPresent()) {
            attributes.put((Object)"reason", (Object)AnalyticsMessageHandler.messageHandler(reason.get()));
        }
        if (fileName.isPresent()) {
            attributes.put((Object)"fileName", (Object)fileName.get());
        }
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"confluenceVersion", (Object)confluenceInfo.getVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject("migration", migrationId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildErrorOperationalEvent(ErrorEvent errorEvent) {
        return this.buildErrorOperationalEvent(errorEvent, this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes());
    }

    public EventDto buildErrorOperationalEventForSpaceExport(ErrorEvent errorEvent, ExportType exportType) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"spaceExportType", (Object)exportType);
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    public EventDto buildErrorOperationalEventForSpaceImport(ErrorEvent errorEvent, ImportType importType, Optional<String> optionalImportTaskId, Optional<Integer> optionalStatusCode) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"spaceImportType", (Object)importType);
        optionalStatusCode.ifPresent(statusCode -> attributes.put((Object)"statusCode", statusCode));
        optionalImportTaskId.ifPresent(importTaskId -> attributes.put((Object)"importTaskId", importTaskId));
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    public EventDto buildErrorOperationalEventForSpaceUpload(ErrorEvent errorEvent, UploadDestinationType uploadDestinationType) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"spaceUploadType", (Object)uploadDestinationType);
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    public EventDto buildErrorOperationalEventWithImportTaskId(ErrorEvent errorEvent, Optional<String> optionalImportTaskId) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        optionalImportTaskId.ifPresent(importTaskId -> attributes.put((Object)"importTaskId", importTaskId));
        return this.buildErrorOperationalEvent(errorEvent, attributes);
    }

    private EventDto buildErrorOperationalEvent(ErrorEvent errorEvent, ImmutableMap.Builder<String, Object> initialAttributes) {
        ImmutableMap.Builder finalAttributes = new ImmutableMap.Builder();
        finalAttributes.putAll((Map)initialAttributes.build());
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        finalAttributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        finalAttributes.put((Object)"errorCode", (Object)errorEvent.getErrorCode().getCode());
        finalAttributes.put((Object)"reason", (Object)AnalyticsMessageHandler.messageHandler(errorEvent.getReason()));
        finalAttributes.put((Object)"configuredHeapSize", (Object)Long.toString(configuredHeapSize));
        finalAttributes.put((Object)"type", (Object)errorEvent.getType().name());
        this.analyticsEventBuilderUtil.feedSpaceIdIfPresent(errorEvent.getSpaceKey(), spaceId -> finalAttributes.put((Object)"spaceId", (Object)Long.toString(spaceId)));
        this.analyticsEventBuilderUtil.addConfluenceAndDBVersionInAttributes((ImmutableMap.Builder<String, Object>)finalAttributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("logged")).sen(this.senSupplier.get())).source("knownSource")).cloudId(errorEvent.getCloudId())).actionSubject("objectFailure")).contextContainer(errorEvent.getContainerType().getName(), errorEvent.getContainerId())).withAttributes((Map)finalAttributes.build())).build();
    }
}

