DECLARE @SchemaName    VARCHAR(256)
DECLARE @TableName     VARCHAR(256)
DECLARE @IndexName     VARCHAR(256)
DECLARE @TSQLDropIndex VARCHAR(MAX)

DECLARE CursorIndexes CURSOR FOR
SELECT schema_name(t.schema_id), t.name, i.name
FROM sys.indexes i
         INNER JOIN sys.tables t ON t.object_id = i.object_id
         INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
         INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE i.type > 0
  AND t.is_ms_shipped = 0
  AND t.name = 'MIG_CLOUD_SITE'
  AND is_unique_constraint = 1
  AND c.name = 'containerToken'

    OPEN CursorIndexes
FETCH NEXT FROM CursorIndexes INTO @SchemaName,@TableName,@IndexName

    WHILE @@fetch_status = 0
BEGIN
        SET @TSQLDropIndex =
                    'ALTER TABLE ' + QUOTENAME(@SchemaName) + '.' + QUOTENAME(@TableName) + ' DROP CONSTRAINT ' +
                    QUOTENAME(@IndexName)
        EXECUTE (@TSQLDropIndex)
        FETCH NEXT FROM CursorIndexes INTO @SchemaName,@TableName,@IndexName
END

CLOSE CursorIndexes
    DEALLOCATE CursorIndexes

ALTER TABLE MIG_CLOUD_SITE DROP CONSTRAINT DF_MIG_CLOUD_SITE_cloudType;