/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.util;

import com.atlassian.migration.agent.service.guardrails.OpenCsvEncoder;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.ws.rs.core.StreamingOutput;

public class CsvBuilder<T> {
    private final Map<String, Function<T, Object>> mappings = new LinkedHashMap<String, Function<T, Object>>();

    public CsvBuilder<T> addColumn(String name, Object value) {
        return this.addColumn(name, (T t) -> value);
    }

    public CsvBuilder<T> addColumn(String name, Function<T, Object> getter) {
        this.mappings.put(name, getter);
        return this;
    }

    public Path build(Path csvFilePath, List<T> records) throws IOException {
        OpenCsvEncoder encoder = new OpenCsvEncoder();
        StreamingOutput csvStreamingOutput = output -> {
            try (CSVWriter csvWriter = new CSVWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), ',', '\"', '\u0000', "\r\n");){
                csvWriter.writeNext(this.mappings.keySet().toArray(new String[0]), false);
                for (Object t : records) {
                    String[] values = (String[])this.mappings.values().stream().map(f -> {
                        Object value = f.apply(t);
                        String encodedData = Objects.toString(value, "");
                        return encoder.encode(encodedData);
                    }).toArray(String[]::new);
                    csvWriter.writeNext(values, false);
                }
            }
            catch (IOException e) {
                throw new IOException("Unable to generate CSV file for instance assessment", e);
            }
        };
        Files.createDirectories(csvFilePath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(csvFilePath);
        Files.createFile(csvFilePath, new FileAttribute[0]);
        csvStreamingOutput.write(Files.newOutputStream(csvFilePath, new OpenOption[0]));
        return csvFilePath;
    }
}

