/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.model.stats.GlobalEntitiesStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public class GlobalEntitiesAnalyticsEventBuilder {
    private final PluginVersionManager pluginVersionManager;
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final StatisticsService statisticsService;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;

    public GlobalEntitiesAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SENSupplier senSupplier, StatisticsService statisticsService, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this(pluginVersionManager, senSupplier, Instant::now, statisticsService, analyticsEventBuilderUtil);
    }

    @VisibleForTesting
    GlobalEntitiesAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SENSupplier senSupplier, Supplier<Instant> instantSupplier, StatisticsService statisticsService, AnalyticsEventBuilderUtil analyticsEventBuilderUtil) {
        this.pluginVersionManager = pluginVersionManager;
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.statisticsService = statisticsService;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
    }

    public EventDto buildGlobalEntitiesConflictingExportStepEvent(Long numOfGlobalPageTemplatesMigrated, Long numOfSystemTemplatesMigrated, String planId, String taskId, String migrationId) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"numOfSystemTemplatesMigrated", (Object)Long.toString(numOfSystemTemplatesMigrated));
        attributes.put((Object)"numOfGlobalPageTemplatesMigrated", (Object)Long.toString(numOfGlobalPageTemplatesMigrated));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"migrationId", (Object)migrationId);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("globalEntitiesCSVExported")).sen(this.senSupplier.get())).actionSubject("globalEntity", taskId)).withAttributes((Map)attributes.build())).contextContainer("plan", planId)).build();
    }

    public EventDto buildGlobalEntitiesTableExportedToCSVTimerEvent(boolean stepSuccessful, long totalTime, String planId, String cloudId, String taskId, String tableName, String query, String dbType, long timeToFirstRecord, long rowsExported, long charactersExported) {
        Map<String, Object> attributes = this.analyticsEventBuilderUtil.buildTableExportedToCSVTimerEvent(tableName, query, dbType, timeToFirstRecord, rowsExported, charactersExported);
        return this.buildGlobalEntitiesStepTimerEvent(stepSuccessful, totalTime, "tableExportedToCSV", planId, cloudId, taskId, attributes);
    }

    public EventDto buildGlobalEntitiesExportStepTimerEvent(boolean stepSuccessful, long totalTime, String planId, String cloudId, String taskId) {
        return this.buildGlobalEntitiesStepTimerEvent(stepSuccessful, totalTime, "globalEntitiesExported", planId, cloudId, taskId);
    }

    public EventDto buildGlobalEntitiesUploadStepTimerEvent(boolean stepSuccessful, long totalTime, String planId, String cloudId, String taskId, long uploadSize) {
        return this.buildGlobalEntitiesStepTimerEvent(stepSuccessful, totalTime, "globalEntitiesUploaded", planId, cloudId, taskId, (Map<String, Object>)ImmutableMap.of((Object)"uploadSize", (Object)uploadSize));
    }

    public EventDto buildGlobalEntitiesMCSFileUploadTimerEvent(boolean stepSuccessful, long totalTime, String planId, String cloudId, String taskId, long uploadSize, String filename) {
        return this.buildGlobalEntitiesStepTimerEvent(stepSuccessful, totalTime, "globalEntitiesFileUploadedToMCS", planId, cloudId, taskId, (Map<String, Object>)ImmutableMap.of((Object)"uploadSize", (Object)uploadSize, (Object)"fileName", (Object)filename));
    }

    public EventDto buildGlobalEntitiesUploadStartEvent(Step step, long startTime, String fileId) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.getBuilderStartedEvent(step, startTime);
        stepBuilder.addAttribute("fileId", (Object)fileId);
        return stepBuilder.build();
    }

    public EventDto buildGlobalEntitiesImportStepTimerEvent(boolean stepSuccessful, long totalTime, String planId, String cloudId, String taskId) {
        return this.buildGlobalEntitiesStepTimerEvent(stepSuccessful, totalTime, "globalEntitiesImported", planId, cloudId, taskId);
    }

    public EventDto buildGlobalEntitiesExportImportStartEvent(Step step, long startTime) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.getBuilderStartedEvent(step, startTime);
        return stepBuilder.build();
    }

    @VisibleForTesting
    public EventDto buildGlobalEntitiesStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String planId, String cloudId, String taskId) {
        return this.buildGlobalEntitiesStepTimerEvent(stepSuccessful, totalTime, action, planId, cloudId, taskId, Collections.emptyMap());
    }

    @VisibleForTesting
    public EventDto buildGlobalEntitiesStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String planId, String cloudId, String taskId, Map<String, Object> additionalAttributes) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"stepSuccessful", (Object)stepSuccessful);
        this.addGlobalEntitiesStatsToAttributes((ImmutableMap.Builder<String, Object>)attributes, this.statisticsService.getGlobalEntitiesStatistics(planId));
        attributes.put((Object)"timeTaken", (Object)Long.toString(totalTime));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.putAll(additionalAttributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject("globalEntity", taskId)).withAttributes((Map)attributes.build())).cloudId(cloudId)).contextContainer("plan", planId)).build();
    }

    private void addGlobalEntitiesStatsToAttributes(ImmutableMap.Builder<String, Object> attributes, GlobalEntitiesStats globalEntitiesStats) {
        attributes.put((Object)"totalGlobalPageTemplates", (Object)Long.toString(globalEntitiesStats.getNumberOfGlobalPageTemplates()));
        attributes.put((Object)"totalCustomSystemTemplates", (Object)Long.toString(globalEntitiesStats.getNumberOfEditedSystemTemplates()));
    }
}

