/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mma.model.processor;

import com.atlassian.migration.agent.newexport.processor.RowProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceCategoriesRowProcessor
implements RowProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceCategoriesRowProcessor.class);
    private static final String SPACEID_COLUMN = "SPACEID";
    private static final String LABELNAME_COLUMN = "LABELNAME";
    private volatile boolean closed = false;
    private final Map<Long, List<String>> spaceLabels = new HashMap<Long, List<String>>();

    @Override
    public void process(ResultSet rs) {
        if (this.closed) {
            throw new IllegalStateException("Attempted to process more space labels after the result was consumed.");
        }
        try {
            Long spaceId = rs.getLong(SPACEID_COLUMN);
            this.spaceLabels.putIfAbsent(spaceId, new ArrayList());
            this.spaceLabels.get(spaceId).add(rs.getString(LABELNAME_COLUMN));
        }
        catch (SQLException e) {
            log.error("Error while fetching space labels for metadata update", (Throwable)e);
            throw new RuntimeException("Error while fetching space labels for metadata update", e);
        }
    }

    public Map<Long, List<String>> getSpaceLabels() {
        this.closed = true;
        return this.spaceLabels;
    }
}

