/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.json;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.migration.agent.json.JsonSerializingException;
import com.atlassian.migration.json.EditionDeserializerFasterXml;
import com.atlassian.migration.json.EditionSerializerFasterXml;
import com.atlassian.migration.json.InstantDeserializerFasterXml;
import com.atlassian.migration.json.InstantSerializerFasterXml;
import com.atlassian.migration.json.LocalDateDeserializerFasterXml;
import com.atlassian.migration.json.LocalDateSerializerFasterXml;
import com.atlassian.migration.json.LocalTimeDeserializerFasterXml;
import com.atlassian.migration.json.LocalTimeSerializerFasterXml;
import com.atlassian.migration.json.ProductDeserializerFasterXml;
import com.atlassian.migration.json.ProductSerializerFasterXml;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;

public class Jsons {
    public static final ObjectMapper OBJECT_MAPPER = Jsons.initialize();

    private Jsons() {
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to read a value from a JSON string", e);
        }
    }

    public static void writeValue(OutputStream o, Object value) {
        try {
            OBJECT_MAPPER.writeValue(o, value);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to write a value to a JSON string", e);
        }
    }

    public static <T> T readValue(Reader r, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(r, clazz);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to read a value from a JSON string", e);
        }
    }

    public static JsonNode readTree(Reader src) {
        try {
            return OBJECT_MAPPER.readTree(src);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to read a value from a JSON string", e);
        }
    }

    public static <T> T treeToValue(JsonNode node, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.treeToValue((TreeNode)node, valueType);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to read a value from a JSON string", e);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)OBJECT_MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T> T readValue(Reader src, TypeReference<T> typeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, typeRef);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to read a value from a JSON string", e);
        }
    }

    public static <T> T readValue(String json, TypeReference typeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, typeRef);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to read a value from a JSON string", e);
        }
    }

    public static <T> T readValue(File src, TypeReference typeRef) throws IOException {
        return (T)OBJECT_MAPPER.readValue(src, typeRef);
    }

    public static <T> T readValue(InputStream src, Class<T> valueType) throws IOException {
        return (T)OBJECT_MAPPER.readValue(src, valueType);
    }

    public static <T> T readValue(InputStream src, TypeReference typeRef) throws IOException {
        return (T)OBJECT_MAPPER.readValue(src, typeRef);
    }

    public static String valueAsString(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new JsonSerializingException("Failed to write a value to a JSON string", e);
        }
    }

    public static void valueAsJsonFile(File resultFile, Object value) throws IOException {
        OBJECT_MAPPER.writeValue(resultFile, value);
    }

    private static ObjectMapper initialize() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(Jsons.createModule());
        return mapper;
    }

    public static Module createModule() {
        return new SimpleModule("Migration Agent", Version.unknownVersion()).addSerializer(Instant.class, (JsonSerializer)new InstantSerializerFasterXml()).addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializerFasterXml()).addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializerFasterXml()).addSerializer(Edition.class, (JsonSerializer)new EditionSerializerFasterXml()).addSerializer(Product.class, (JsonSerializer)new ProductSerializerFasterXml()).addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializerFasterXml()).addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializerFasterXml()).addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializerFasterXml()).addDeserializer(Edition.class, (JsonDeserializer)new EditionDeserializerFasterXml()).addDeserializer(Product.class, (JsonDeserializer)new ProductDeserializerFasterXml());
    }
}

