/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.async;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.udc.async.EventBus;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CCMAEventBus
implements EventBus {
    private static final Logger log = ContextLoggerFactory.getLogger(CCMAEventBus.class);
    private final AnalyticsEventService analyticsEventService;

    public void post(@NotNull Object event) {
        if (event instanceof EventDto) {
            this.safelyPostAnalyticsEvent((EventDto)event);
        } else {
            log.debug("Cannot handle Event {}, ignoring", event);
        }
    }

    private void safelyPostAnalyticsEvent(EventDto event) {
        try {
            this.analyticsEventService.saveAnalyticsEventAsync(() -> event);
        }
        catch (Exception e) {
            log.warn("Failed to post analytics event", (Throwable)e);
        }
    }

    @Generated
    public CCMAEventBus(AnalyticsEventService analyticsEventService) {
        this.analyticsEventService = analyticsEventService;
    }
}

