/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries.membership;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public final class MembershipEntityCounts {
    private final long[] ids;
    private final long[] counts;
    private final int averageCount;
    private final long maxCount;
    private final TreeMap<Long, Set<Long>> topIds = new TreeMap(Comparator.reverseOrder());

    public MembershipEntityCounts(long[] ids, long[] counts) {
        this.ids = ids;
        this.counts = counts;
        long sum = 0L;
        long max = 0L;
        for (long count : counts) {
            max = Math.max(max, count);
            sum += count;
        }
        this.maxCount = max;
        this.averageCount = counts.length == 0 ? 0 : (int)(sum / (long)counts.length);
        for (int i = 0; i < counts.length; ++i) {
            int finalIdx = i;
            this.topIds.computeIfAbsent(counts[i], v -> this.setOf(ids[finalIdx]));
            this.topIds.computeIfPresent(counts[i], (k, v) -> this.setOf(ids[finalIdx], (Set<Long>)v));
        }
    }

    public List<Pair<Long, Long>> getTopIds(int limit, Predicate<Pair<Long, Long>> filter) {
        return this.topIds.entrySet().stream().map(this::createPairs).flatMap(Collection::stream).filter(filter).limit(limit).collect(Collectors.toList());
    }

    public List<Pair<Long, Long>> getTopIds(Predicate<Pair<Long, Long>> filter) {
        return this.getTopIds(this.ids.length, filter);
    }

    public List<Pair<Long, Long>> getTopIds(int limit) {
        return this.getTopIds(limit, ignore -> true);
    }

    private List<Pair<Long, Long>> createPairs(Map.Entry<Long, Set<Long>> entry) {
        return entry.getValue().stream().map(id -> Pair.of((Object)id, (Object)((Long)entry.getKey()))).collect(Collectors.toList());
    }

    private Set<Long> setOf(long id) {
        HashSet<Long> set = new HashSet<Long>();
        set.add(id);
        return set;
    }

    private Set<Long> setOf(long id, Set<Long> existing) {
        HashSet<Long> newSet = new HashSet<Long>(existing);
        newSet.add(id);
        return newSet;
    }

    @Generated
    public long[] getIds() {
        return this.ids;
    }

    @Generated
    public long[] getCounts() {
        return this.counts;
    }

    @Generated
    public int getAverageCount() {
        return this.averageCount;
    }

    @Generated
    public long getMaxCount() {
        return this.maxCount;
    }

    @Generated
    public TreeMap<Long, Set<Long>> getTopIds() {
        return this.topIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MembershipEntityCounts)) {
            return false;
        }
        MembershipEntityCounts other = (MembershipEntityCounts)o;
        if (this.getAverageCount() != other.getAverageCount()) {
            return false;
        }
        if (this.getMaxCount() != other.getMaxCount()) {
            return false;
        }
        if (!Arrays.equals(this.getIds(), other.getIds())) {
            return false;
        }
        if (!Arrays.equals(this.getCounts(), other.getCounts())) {
            return false;
        }
        TreeMap<Long, Set<Long>> this$topIds = this.getTopIds();
        TreeMap<Long, Set<Long>> other$topIds = other.getTopIds();
        return !(this$topIds == null ? other$topIds != null : !((Object)this$topIds).equals(other$topIds));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAverageCount();
        long $maxCount = this.getMaxCount();
        result = result * 59 + (int)($maxCount >>> 32 ^ $maxCount);
        result = result * 59 + Arrays.hashCode(this.getIds());
        result = result * 59 + Arrays.hashCode(this.getCounts());
        TreeMap<Long, Set<Long>> $topIds = this.getTopIds();
        result = result * 59 + ($topIds == null ? 43 : ((Object)$topIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MembershipEntityCounts(ids=" + Arrays.toString(this.getIds()) + ", counts=" + Arrays.toString(this.getCounts()) + ", averageCount=" + this.getAverageCount() + ", maxCount=" + this.getMaxCount() + ", topIds=" + this.getTopIds() + ")";
    }
}

