/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.InvalidEmailsConfigDto;
import com.atlassian.migration.agent.service.check.email.DuplicateEmailCheckContext;
import com.atlassian.migration.agent.service.check.email.InvalidEmailCheckContext;
import com.atlassian.migration.agent.service.email.FixAllEmailsResult;
import com.atlassian.migration.agent.service.email.GlobalEmailFixesConfigService;
import com.atlassian.migration.agent.service.email.InvalidEmailValidator;
import com.atlassian.migration.agent.service.email.UserBaseScanRunner;
import com.atlassian.migration.agent.service.email.UserEmailFixer;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupportedUserHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnsupportedUserHandler.class);
    public static final String UDC_MODE_KEY = "info_udcMode";
    public static final String CSV_STATE = "info_csvState";
    private final UserAccessor userAccessor;
    private final UserEmailFixer userEmailFixer;
    private final InvalidEmailValidator invalidEmailValidator;
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final UserBaseScanRunner userBaseScanRunner;

    public CheckResult resolveCheckResult(String cloudId, CheckResult checkResult, InvalidEmailCheckContext checkContext) {
        CheckResult resolvedCheckResult;
        if (this.isAdvancedMode()) {
            List<MigrationUser> invalidMigrationUsers = UnsupportedUserHandler.getViolations(checkResult).stream().map(it -> this.userAccessor.getUserByName(it.id)).map(it -> new MigrationUser(it.getKey().getStringValue(), it.getName(), it.getFullName(), it.getEmail(), !this.userAccessor.isDeactivated((User)it))).collect(Collectors.toList());
            FixAllEmailsResult result = this.userEmailFixer.fixAllEmailsInMemory(checkContext.getPayload().getUsers().stream().map(it -> new MigrationUser(it.getUserKey(), it.getUserName(), it.getFullName(), it.getEmail(), it.isActive())).collect(Collectors.toList()), cloudId, invalidMigrationUsers, false);
            resolvedCheckResult = this.advancedCheckResult(this.isCsvValid(result.getInvalidUsers(), CollectionUtils.union((Iterable)CollectionUtils.emptyIfNull(result.getNewMailForInvalid()), (Iterable)CollectionUtils.emptyIfNull(result.getNewMailForValid())), cloudId), checkResult);
        } else if (checkResult.success) {
            resolvedCheckResult = this.basicCheckResult(true, checkResult);
        } else {
            InvalidEmailsConfigDto invalidEmailsConfig = this.globalEmailFixesConfigService.getInvalidEmailsConfig();
            switch (invalidEmailsConfig.getActionOnMigration()) {
                case DO_NOTHING: {
                    resolvedCheckResult = this.basicCheckResult(false, checkResult);
                    break;
                }
                case TOMBSTONE_ALL: 
                case USE_NEW_EMAILS: {
                    resolvedCheckResult = this.basicCheckResult(true, checkResult);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)invalidEmailsConfig.getActionOnMigration()));
                }
            }
        }
        this.startUserBaseScan(cloudId, resolvedCheckResult);
        return resolvedCheckResult;
    }

    public CheckResult resolveCheckResult(String cloudId, CheckResult checkResult, DuplicateEmailCheckContext checkContext) {
        CheckResult resolvedCheckResult;
        if (this.isAdvancedMode()) {
            FixAllEmailsResult result = this.userEmailFixer.fixAllEmailsInMemory(new ArrayList<MigrationUser>(checkContext.getMigrationUsers()), cloudId, false);
            resolvedCheckResult = this.advancedCheckResult(this.isCsvValid(result.getDuplicateUsers(), result.getNewMailForDuplicate(), cloudId), checkResult);
        } else if (checkResult.success) {
            resolvedCheckResult = this.basicCheckResult(true, checkResult);
        } else {
            DuplicateEmailsConfigDto duplicateEmailsConfig = this.globalEmailFixesConfigService.getDuplicateEmailsConfig();
            switch (duplicateEmailsConfig.getActionOnMigration()) {
                case DO_NOTHING: {
                    resolvedCheckResult = this.basicCheckResult(false, checkResult);
                    break;
                }
                case MERGE_ALL: 
                case USE_NEW_EMAILS: {
                    resolvedCheckResult = this.basicCheckResult(true, checkResult);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)duplicateEmailsConfig.getActionOnMigration()));
                }
            }
        }
        this.startUserBaseScan(cloudId, resolvedCheckResult);
        return resolvedCheckResult;
    }

    private void startUserBaseScan(String cloudId, CheckResult resolvedCheckResult) {
        if (!resolvedCheckResult.success && !this.migrationDarkFeaturesManager.isGlobalEmailFixesNewEmailsFromDbEnabled()) {
            this.userBaseScanRunner.startUserBaseScan(cloudId);
        }
    }

    private boolean isAdvancedMode() {
        return this.globalEmailFixesConfigService.getUdcModeConfig() == UDCMode.ADVANCED;
    }

    private static List<EmailData> getViolations(CheckResult checkResult) {
        return (List)checkResult.details.get("violations");
    }

    private CsvState isCsvValid(List<MigrationUser> faultyEmailsCollection, Collection<MigrationUser> emailsToValidate, String cloudId) {
        if (!CollectionUtils.isEmpty(faultyEmailsCollection)) {
            return CsvState.OUTDATED;
        }
        if (!this.areEmailValid(emailsToValidate, cloudId)) {
            return CsvState.INVALID_EMAILS_IN_CSV;
        }
        return CsvState.VALID;
    }

    private boolean areEmailValid(Collection<MigrationUser> emailsToValidate, String cloudId) {
        return CollectionUtils.isEmpty(this.invalidEmailValidator.getInvalidEmails(UUID.randomUUID().toString(), cloudId, emailsToValidate));
    }

    private CheckResult advancedCheckResult(CsvState csvState, CheckResult sourceCheckResult) {
        return new CheckResult(csvState == CsvState.VALID, (Map)ImmutableMap.builder().putAll(sourceCheckResult.details).put((Object)UDC_MODE_KEY, (Object)UDCMode.ADVANCED.name()).put((Object)CSV_STATE, (Object)csvState.name()).build());
    }

    private CheckResult basicCheckResult(boolean success, CheckResult sourceCheckResult) {
        return new CheckResult(success, (Map)ImmutableMap.builder().putAll(sourceCheckResult.details).put((Object)UDC_MODE_KEY, (Object)UDCMode.BASIC.name()).build());
    }

    @Generated
    public UnsupportedUserHandler(UserAccessor userAccessor, UserEmailFixer userEmailFixer, InvalidEmailValidator invalidEmailValidator, GlobalEmailFixesConfigService globalEmailFixesConfigService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, UserBaseScanRunner userBaseScanRunner) {
        this.userAccessor = userAccessor;
        this.userEmailFixer = userEmailFixer;
        this.invalidEmailValidator = invalidEmailValidator;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.userBaseScanRunner = userBaseScanRunner;
    }

    public static enum CsvState {
        VALID,
        OUTDATED,
        INVALID_EMAILS_IN_CSV;

    }
}

