/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.migration.agent.service.email.DuplicateEmailsFixResult;
import com.atlassian.migration.agent.service.email.FixAllEmailsResult;
import com.atlassian.migration.agent.service.email.GlobalUnsupportedUserHandler;
import com.atlassian.migration.agent.service.email.InvalidEmailValidator;
import com.atlassian.migration.agent.service.email.InvalidEmailsFixResult;
import com.atlassian.migration.agent.service.email.MostFrequentDomainService;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class UserEmailFixer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserEmailFixer.class);
    private final GlobalUnsupportedUserHandler globalUnsupportedUserHandler;
    private final InvalidEmailValidator invalidEmailValidator;
    private final MostFrequentDomainService mostFrequentDomainService;

    public UserEmailFixer(GlobalUnsupportedUserHandler globalUnsupportedUserHandler, InvalidEmailValidator invalidEmailValidator, MostFrequentDomainService mostFrequentDomainService) {
        this.globalUnsupportedUserHandler = globalUnsupportedUserHandler;
        this.invalidEmailValidator = invalidEmailValidator;
        this.mostFrequentDomainService = mostFrequentDomainService;
    }

    public FixAllEmailsResult fixAllEmailsInMemory(Collection<MigrationUser> users, String cloudId, List<MigrationUser> invalidEmails, boolean shouldRefreshMostFrequentDomain) {
        if (shouldRefreshMostFrequentDomain) {
            this.mostFrequentDomainService.refreshMostFrequentDomainName();
        }
        EmailCheckContext emailCheckContext = UserEmailFixer.createEmailCheckContext(users);
        Map<String, MigrationUser> userNameToUserMap = UserEmailFixer.getUserNameToUserMap(users);
        InvalidEmailsFixResult invalidEmailsFixResult = this.globalUnsupportedUserHandler.applyInvalidEmailsStrategy(invalidEmails, cloudId);
        List<MigrationUser> duplicateEmails = this.getUsersWithDuplicateEmails(emailCheckContext, userNameToUserMap);
        duplicateEmails.removeAll(invalidEmails);
        DuplicateEmailsFixResult duplicateEmailsFixResult = this.globalUnsupportedUserHandler.applyDuplicateEmailsStrategy(duplicateEmails, cloudId);
        Collection invalidOrDuplicatedUsers = CollectionUtils.union(invalidEmails, duplicateEmails);
        FixAllEmailsResult userMappingResult = this.globalUnsupportedUserHandler.applyUserMappings(users.stream().filter(it -> !invalidOrDuplicatedUsers.contains(it)).collect(Collectors.toList()));
        return new FixAllEmailsResult.Builder().newMailUsers(Stream.of(CollectionUtils.emptyIfNull(invalidEmailsFixResult.getNewMailUsers()), CollectionUtils.emptyIfNull(duplicateEmailsFixResult.getNewMailUsers()), CollectionUtils.emptyIfNull(userMappingResult.getNewMailUsers())).flatMap(Collection::stream).collect(Collectors.toList())).invalidUsers(invalidEmailsFixResult.getInvalidUsers()).tombstoneUsers(Stream.of(CollectionUtils.emptyIfNull(invalidEmailsFixResult.getTombstoneUsers()), CollectionUtils.emptyIfNull(duplicateEmailsFixResult.getTombstoneUsers()), CollectionUtils.emptyIfNull(userMappingResult.getTombstoneUsers())).flatMap(Collection::stream).collect(Collectors.toList())).duplicateUsers(duplicateEmailsFixResult.getDuplicateUsers()).mergeUsers(duplicateEmailsFixResult.getMergeUsers()).validUsers(userMappingResult.getValidUsers()).newMailForValid(userMappingResult.getNewMailUsers()).newMailForInvalid(invalidEmailsFixResult.getNewMailUsers()).newMailForDuplicate(duplicateEmailsFixResult.getNewMailUsers()).build();
    }

    public FixAllEmailsResult fixAllEmailsInMemory(Collection<MigrationUser> users, String cloudId) {
        return this.fixAllEmailsInMemory(users, cloudId, true);
    }

    public FixAllEmailsResult fixAllEmailsInMemory(Collection<MigrationUser> users, String cloudId, boolean shouldRefreshMostFrequentDomain) {
        Map<String, MigrationUser> userNameToUserMap = UserEmailFixer.getUserNameToUserMap(users);
        List<MigrationUser> invalidEmails = this.getUsersWithInvalidEmailsViaUMS(users, userNameToUserMap, cloudId);
        return this.fixAllEmailsInMemory(users, cloudId, invalidEmails, shouldRefreshMostFrequentDomain);
    }

    @NotNull
    private static Map<String, MigrationUser> getUserNameToUserMap(Collection<MigrationUser> users) {
        return users.stream().collect(Collectors.toMap(MigrationUser::getUsername, user -> user));
    }

    @NotNull
    private static EmailCheckContext createEmailCheckContext(Collection<MigrationUser> users) {
        List emailData = users.stream().map(user -> new EmailData(user.getUsername(), user.getEmail())).collect(Collectors.toList());
        return new EmailCheckContext(emailData);
    }

    private List<MigrationUser> getUsersWithInvalidEmailsViaUMS(Collection<MigrationUser> users, Map<String, MigrationUser> userNameToUserMap, String cloudId) {
        List<EmailData> invalidEmails = this.invalidEmailValidator.getInvalidEmails(UUID.randomUUID().toString(), cloudId, users);
        return invalidEmails.stream().map(it -> (MigrationUser)userNameToUserMap.get(it.id)).collect(Collectors.toList());
    }

    private List<MigrationUser> getUsersWithDuplicateEmails(EmailCheckContext emailCheckContext, Map<String, MigrationUser> userNameToUserMap) {
        CheckResult checkResult = new EmailDuplicateChecker().check(emailCheckContext);
        List duplicateEmails = EmailDuplicateChecker.retrieveEmailDuplicates((Map)checkResult.details);
        return duplicateEmails.stream().flatMap(it -> it.ids.stream()).map(userNameToUserMap::get).collect(Collectors.toList());
    }
}

