/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class SpaceUsersAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final Supplier<Instant> instantSupplier;

    public SpaceUsersAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SENSupplier senSupplier) {
        this(pluginVersionManager, Instant::now, senSupplier);
    }

    @VisibleForTesting
    SpaceUsersAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, Supplier<Instant> instantSupplier, SENSupplier senSupplier) {
        this.pluginVersionManager = pluginVersionManager;
        this.instantSupplier = instantSupplier;
        this.senSupplier = senSupplier;
    }

    public EventDto buildSpaceUsersMigratedEvent(int userWithValidEmails, int usersToTombstone, long spaceId, String migrationId) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"usersWithValidEmails", (Object)userWithValidEmails);
        attributes.put((Object)"usersToTombstone", (Object)usersToTombstone);
        attributes.put((Object)"spaceId", (Object)String.valueOf(spaceId));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("usersForSpaceUsersMigration")).sen(this.senSupplier.get())).actionSubject("migration", migrationId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceUserStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String migrationId, long spaceId) {
        return this.buildSpaceUserStepTimerEvent(stepSuccessful, totalTime, action, migrationId, -1, spaceId);
    }

    public EventDto buildSpaceUserStepTimerEvent(boolean stepSuccessful, long totalTime, String action, String migrationId, int userCount, long spaceId) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"stepSuccessful", (Object)stepSuccessful);
        attributes.put((Object)"userCount", (Object)String.valueOf(userCount));
        attributes.put((Object)"timeTaken", (Object)Long.toString(totalTime));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"spaceId", (Object)Long.toString(spaceId));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).actionSubject("migration", migrationId)).withAttributes((Map)attributes.build())).build();
    }
}

