/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.confluence.cluster.ClusterInformation;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.InstanceStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.rest.QueryFailedException;
import com.atlassian.migration.agent.service.NetworkStatisticsService;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventConstants;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.encryption.EncryptionConfigHandler;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class ServerMetadataAnalyticsEventBuilder {
    public static final String PRODUCT_VERSION_ATTRIBUTE_NAME = "productVersion";
    public static final String SUCCESS_ATTRIBUTE_NAME = "successful";
    public static final String TIME_TAKEN_ATTRIBUTE_NAME = "timeTaken";
    public static final String ERROR_ATTRIBUTE_NAME = "error";
    public static final String ERRORS_ATTRIBUTE_NAME = "errors";
    public static final String ERROR_DETAILS_NAME = "errorDetails";
    public static final String ENTITIES_AFFECTED_ATTRIBUTE_NAME = "numEntitiesAffected";
    public static final String FAILURE_COUNT_ATTRIBUTE_NAME = "failureBatchCount";
    private final SystemInformationService systemInformationService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final PluginMetadataManager pluginMetadataManager;
    private final ClusterManager clusterManager;
    private final PluginVersionManager pluginVersionManager;
    private final EncryptionConfigHandler encryptionConfigHandler;
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final StatisticsService statisticsService;
    private final LicenseHandler licenseHandler;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public ServerMetadataAnalyticsEventBuilder(SystemInformationService systemInformationService, CrowdDirectoryService crowdDirectoryService, PluginMetadataManager pluginMetadataManager, ClusterManager clusterManager, PluginVersionManager pluginVersionManager, EncryptionConfigHandler encryptionConfigHandler, SENSupplier senSupplier, StatisticsService statisticsService, LicenseHandler licenseHandler, MigrationAgentConfiguration migrationAgentConfiguration, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this(systemInformationService, crowdDirectoryService, pluginMetadataManager, clusterManager, pluginVersionManager, encryptionConfigHandler, senSupplier, Instant::now, statisticsService, licenseHandler, migrationAgentConfiguration, analyticsEventBuilderUtil, migrationDarkFeaturesManager);
    }

    @VisibleForTesting
    ServerMetadataAnalyticsEventBuilder(SystemInformationService systemInformationService, CrowdDirectoryService crowdDirectoryService, PluginMetadataManager pluginMetadataManager, ClusterManager clusterManager, PluginVersionManager pluginVersionManager, EncryptionConfigHandler encryptionConfigHandler, SENSupplier senSupplier, Supplier<Instant> instantSupplier, StatisticsService statisticsService, LicenseHandler licenseHandler, MigrationAgentConfiguration migrationAgentConfiguration, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.systemInformationService = systemInformationService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.pluginMetadataManager = pluginMetadataManager;
        this.clusterManager = clusterManager;
        this.pluginVersionManager = pluginVersionManager;
        this.encryptionConfigHandler = encryptionConfigHandler;
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.statisticsService = statisticsService;
        this.licenseHandler = licenseHandler;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public EventDto buildCompletedInstanceAnalysisAnalyticsEvent(ServerStats serverStats, ConfluenceUser confluenceUser) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        DatabaseInfo databaseInfo = this.systemInformationService.getDatabaseInfo();
        attributes.put((Object)"database", (Object)ImmutableMap.of((Object)"type", (Object)databaseInfo.getName(), (Object)"version", (Object)databaseInfo.getVersion()));
        long configuredHeapSize = Runtime.getRuntime().maxMemory();
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"apps", (Object)confluenceInfo.getEnabledPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).map(Plugin::getKey).collect(Collectors.toCollection(LinkedList::new)));
        List directories = this.crowdDirectoryService.findAllDirectories();
        boolean ldap = directories.stream().filter(Directory::isActive).map(Directory::getType).anyMatch(AnalyticsEventConstants.LDAP_DIRECTORY_TYPES::contains);
        attributes.put((Object)"LDAP", (Object)ldap);
        attributes.put((Object)"estimatedTime", (Object)Long.toString(serverStats.getTotalSpaceMigrationTime().plus(serverStats.getTotalUserGroupMigrationTime()).plus(MigrationTimeEstimationUtils.getBaseMigrationTime()).getSeconds()));
        attributes.put((Object)"bandwidthKBS", (Object)(serverStats.getBandwidthKBS() == NetworkStatisticsService.getUncalculatedBandwidthKBPS() ? "" : Long.toString(serverStats.getBandwidthKBS())));
        InstanceStats instanceStats = serverStats.getInstanceStats();
        attributes.put((Object)"version", (Object)instanceStats.getVersion());
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(instanceStats.getNumberOfSpaces()));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(instanceStats.getNumberOfUsers()));
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(instanceStats.getNumberOfGroups()));
        ContentSummary contentSummary = serverStats.getContentSummary();
        attributes.put((Object)"totalAttachmentsSize", (Object)Long.toString(contentSummary.getAttachments().getTotalSize() != null ? contentSummary.getAttachments().getTotalSize() : 0L));
        attributes.put((Object)"numberOfPages", (Object)Long.toString(contentSummary.getNumberOfPages() != null ? contentSummary.getNumberOfPages() : 0L));
        attributes.put((Object)"numberOfBlogs", (Object)Long.toString(contentSummary.getNumberOfBlogs() != null ? contentSummary.getNumberOfBlogs() : 0L));
        attributes.put((Object)"numberOfTeamCalendars", (Object)Long.toString(contentSummary.getNumberOfTeamCalendars() != null ? contentSummary.getNumberOfTeamCalendars() : 0L));
        ClusterInformation clusterInformation = this.clusterManager.getClusterInformation();
        attributes.put((Object)"clustered", (Object)this.clusterManager.isClustered());
        attributes.put((Object)"numberOfNodes", (Object)Integer.toString(clusterInformation.getMemberCount()));
        attributes.put((Object)"configuredHeapSize", (Object)Long.toString(configuredHeapSize));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        if (this.migrationDarkFeaturesManager.isTokenEncryptionEnabled()) {
            attributes.put((Object)"encryptionKeyLocation", (Object)this.encryptionConfigHandler.getKeyLocationFromConfig());
        }
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).email(confluenceUser == null ? null : confluenceUser.getEmail())).sen(this.senSupplier.get())).action("completed")).actionSubject("instanceAnalysis")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceStatisticCalculationBatchStepExecutionErrorEvent(String jobId, String executionId, String batchId, String batchStep, int batchSize, boolean includeHistoricalData, Exception e, String spaceId) {
        String calculationExceptionMessage = e == null ? "" : e.getMessage().trim();
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSpaceStatisticBuilderWithCommonAttributes();
        attributes.put((Object)"jobId", (Object)jobId);
        attributes.put((Object)"executionId", (Object)executionId);
        attributes.put((Object)"batchSize", (Object)batchSize);
        attributes.put((Object)"includeHistoricalData", (Object)includeHistoricalData);
        attributes.put((Object)"spaceId", (Object)(spaceId == null ? "" : spaceId));
        attributes.put((Object)ERROR_ATTRIBUTE_NAME, (Object)calculationExceptionMessage.substring(0, Math.min(calculationExceptionMessage.length(), this.migrationAgentConfiguration.getAnalyticsSenderMaxEventLength() / 2)));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).sen(this.senSupplier.get())).source("spaceStatisticCalculation")).action("failed")).actionSubject(batchStep)).contextContainer("batch", batchId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceStatisticCalculationBatchExecutionCompletedEvent(String jobId, String executionId, String batchId, int batchSize, boolean includeHistoricalData, boolean overallSuccess, Map<String, Boolean> executionStepsSuccess, int errorCount, long startTimeEpochMilli, long readEndTimeEpochMilli, long endTimeEpochMilli) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSpaceStatisticBuilderWithCommonAttributes();
        attributes.put((Object)"jobId", (Object)jobId);
        attributes.put((Object)"executionId", (Object)executionId);
        attributes.put((Object)"batchSize", (Object)batchSize);
        attributes.put((Object)"includeHistoricalData", (Object)includeHistoricalData);
        attributes.put((Object)"status", (Object)(overallSuccess ? "success" : "fail"));
        attributes.put((Object)"executionStepsSuccess", executionStepsSuccess);
        attributes.put((Object)"errorCount", (Object)errorCount);
        attributes.put((Object)"startTime", (Object)Instant.ofEpochMilli(startTimeEpochMilli));
        attributes.put((Object)"stopTime", (Object)Instant.ofEpochMilli(endTimeEpochMilli));
        attributes.put((Object)"totalTimeTaken", (Object)(endTimeEpochMilli - startTimeEpochMilli));
        attributes.put((Object)"timeTakenToCalculate", (Object)(readEndTimeEpochMilli - startTimeEpochMilli));
        attributes.put((Object)"timeTakenToStore", (Object)(endTimeEpochMilli - readEndTimeEpochMilli));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).sen(this.senSupplier.get())).source("spaceStatisticCalculation")).action("completed")).actionSubject("batchExecution")).contextContainer("batch", batchId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceStatisticCalculationJobExecutionCompletedEvent(String jobId, String executionId, int spaceCount, int numberOfBatches, int batchSizeLimit, boolean includeHistoricalData, long startTimeEpocMilli, long waitStartTimeEpocMilli, long endTimeEpocMilli) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getSpaceStatisticBuilderWithCommonAttributes();
        attributes.put((Object)"jobId", (Object)jobId);
        attributes.put((Object)"numberOfSpaces", (Object)spaceCount);
        attributes.put((Object)"numberOfBatches", (Object)numberOfBatches);
        attributes.put((Object)"batchSizeLimit", (Object)batchSizeLimit);
        attributes.put((Object)"includeHistoricalData", (Object)includeHistoricalData);
        attributes.put((Object)"startTime", (Object)Instant.ofEpochMilli(startTimeEpocMilli));
        attributes.put((Object)"stopTime", (Object)Instant.ofEpochMilli(endTimeEpocMilli));
        attributes.put((Object)"totalTimeTaken", (Object)(endTimeEpocMilli - startTimeEpocMilli));
        attributes.put((Object)"timeTakenToSubmit", (Object)(waitStartTimeEpocMilli - startTimeEpocMilli));
        attributes.put((Object)"timeTakenToExecute", (Object)(endTimeEpocMilli - waitStartTimeEpocMilli));
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).sen(this.senSupplier.get())).source("spaceStatisticCalculation")).action("completed")).actionSubject("jobExecution")).contextContainer("execution", executionId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildMetadataEvent(String cloudId, ActionType action, ActionSubject actionSubject, long timeTaken, @Nullable Integer batchSize, @Nullable Integer totalEntityCount, @Nullable List<Exception> exceptionList) {
        boolean success = CollectionUtils.isEmpty(exceptionList);
        GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).source("CCMA")).cloudId(cloudId)).sen(this.senSupplier.get())).pluginVersion(this.pluginVersionManager.getPluginVersion())).action(action.value)).actionSubject(actionSubject.value)).addAttribute(PRODUCT_VERSION_ATTRIBUTE_NAME, (Object)this.systemInformationService.getConfluenceInfo().getVersion())).addAttribute(SUCCESS_ATTRIBUTE_NAME, (Object)success)).addAttribute(TIME_TAKEN_ATTRIBUTE_NAME, (Object)timeTaken)).addAttribute("serverId", (Object)this.licenseHandler.getServerId());
        if (batchSize != null) {
            builder = (GenericOperationalEvent.Builder)builder.addAttribute("batchSize", (Object)batchSize);
        }
        if (totalEntityCount != null) {
            builder = (GenericOperationalEvent.Builder)builder.addAttribute(ENTITIES_AFFECTED_ATTRIBUTE_NAME, (Object)totalEntityCount);
        }
        if (!success) {
            builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)builder.addAttribute(FAILURE_COUNT_ATTRIBUTE_NAME, (Object)exceptionList.size())).addAttribute(ERRORS_ATTRIBUTE_NAME, exceptionList.stream().collect(Collectors.groupingBy(e -> e.getClass().getCanonicalName(), Collectors.counting())))).addAttribute(ERROR_DETAILS_NAME, this.getLoggableErrors(exceptionList).stream().collect(Collectors.groupingBy(e -> e.getClass().getCanonicalName(), Collectors.mapping(Throwable::getMessage, Collectors.toList()))));
        }
        return builder.build();
    }

    public EventDto buildServerMetadataEvent(String cloudId, long timeTakenMillis, Optional<Exception> optionalException) {
        GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).source("CCMA")).cloudId(cloudId)).sen(this.senSupplier.get())).pluginVersion(this.pluginVersionManager.getPluginVersion())).action(ActionType.UPDATED.value)).actionSubject(ActionSubject.SERVER_INSTANCE_METADATA.value)).addAttribute(PRODUCT_VERSION_ATTRIBUTE_NAME, (Object)this.systemInformationService.getConfluenceInfo().getVersion())).addAttribute(SUCCESS_ATTRIBUTE_NAME, (Object)(!optionalException.isPresent() ? 1 : 0))).addAttribute("serverId", (Object)this.licenseHandler.getServerId())).addAttribute(TIME_TAKEN_ATTRIBUTE_NAME, (Object)timeTakenMillis);
        optionalException.ifPresent(e -> {
            GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)builder.addAttribute(ERROR_ATTRIBUTE_NAME, (Object)e.getClass().getCanonicalName());
        });
        optionalException.ifPresent(e -> {
            GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)builder.addAttribute(ERROR_DETAILS_NAME, (Object)(this.isLoggableError((Throwable)e) ? e.getMessage() : "Error details were not loggable"));
        });
        return builder.build();
    }

    public EventDto buildMetadataReplaceEvent(String cloudId, long timeTakenMillis, Optional<Exception> optionalException) {
        GenericOperationalEvent.Builder builder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).source("CCMA")).cloudId(cloudId)).sen(this.senSupplier.get())).pluginVersion(this.pluginVersionManager.getPluginVersion())).action(ActionType.REFRESHED.value)).actionSubject(ActionSubject.ALL_METADATA.value, this.licenseHandler.getServerId())).addAttribute(PRODUCT_VERSION_ATTRIBUTE_NAME, (Object)this.systemInformationService.getConfluenceInfo().getVersion())).addAttribute("serverId", (Object)this.licenseHandler.getServerId())).addAttribute(SUCCESS_ATTRIBUTE_NAME, (Object)(!optionalException.isPresent() ? 1 : 0))).addAttribute(TIME_TAKEN_ATTRIBUTE_NAME, (Object)timeTakenMillis);
        optionalException.ifPresent(e -> {
            GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)builder.addAttribute(ERROR_ATTRIBUTE_NAME, (Object)e.getClass().getCanonicalName());
        });
        optionalException.ifPresent(e -> {
            GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)builder.addAttribute(ERROR_DETAILS_NAME, (Object)(this.isLoggableError((Throwable)e) ? e.getMessage() : "Error details were not loggable"));
        });
        return builder.build();
    }

    private List<Exception> getLoggableErrors(List<Exception> exceptions) {
        return exceptions.stream().filter(this::isLoggableError).collect(Collectors.toList());
    }

    @VisibleForTesting
    protected boolean isLoggableError(Throwable throwable) {
        return throwable instanceof QueryFailedException || throwable instanceof NullPointerException || throwable instanceof RuntimeException && throwable.getCause() instanceof QueryFailedException || throwable instanceof RuntimeException && throwable.getCause() instanceof NullPointerException;
    }

    public static enum ActionSubject {
        SPACES("spacesMetadata"),
        APPS("appsMetadata"),
        ALL_METADATA("allMetadata"),
        SERVER_INSTANCE_METADATA("serverInstanceMetadata");

        private final String value;

        private ActionSubject(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ActionType {
        CREATED("created"),
        READ("read"),
        UPDATED("updated"),
        DELETED("deleted"),
        REFRESHED("refreshed");

        private final String value;

        private ActionType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

