/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsTupleElement;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.QueryResult;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipCounts;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipEntityCounts;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipFetcher;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.guardrails.results.LongResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import org.apache.commons.lang3.tuple.Pair;

public class NestedGroupQuery
implements AssessmentQuery {
    private static final int GROUP_SIZE_LIMIT = 35000;
    private static final int LIMIT = 100;
    public static final String GROUP_ID = "group_id";
    public static final String MEMBERSHIP_COUNT = "membership_count";
    public static final String NUMBER_OF_GROUPS = "number_of_groups";
    public static final String USER_ID = "user_id";
    private static final MembershipCounts EXAMPLE = new MembershipCounts(new MembershipEntityCounts(new long[]{309231646L, 676233217L}, new long[]{507L, 558L}), new MembershipEntityCounts(new long[]{778633284L, 897417465L}, new long[]{13674L, 13666L}));
    private final MembershipFetcher membershipFetcher;

    public NestedGroupQuery(MembershipFetcher membershipFetcher) {
        this.membershipFetcher = membershipFetcher;
    }

    @Override
    public Map<QueryIds, QueryResult> executeAll() {
        MembershipCounts membershipCounts = this.membershipFetcher.processDirectories();
        return ImmutableMap.of((Object)((Object)QueryIds.NESTED_GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS), (Object)this.executeNestedMembership(membershipCounts), (Object)((Object)QueryIds.GROUPS_PER_USER), (Object)this.executeNestedGroupsPerUser(membershipCounts), (Object)((Object)QueryIds.GROUP), (Object)this.executeNestedGroup(membershipCounts), (Object)((Object)QueryIds.ALL_USERS), (Object)this.executeAllUsers(membershipCounts));
    }

    @Override
    public Map<QueryIds, QueryResult> examples() {
        return ImmutableMap.of((Object)((Object)QueryIds.NESTED_GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS), (Object)this.executeNestedMembership(EXAMPLE), (Object)((Object)QueryIds.GROUPS_PER_USER), (Object)this.executeNestedGroupsPerUser(EXAMPLE), (Object)((Object)QueryIds.GROUP), (Object)this.executeNestedGroup(EXAMPLE), (Object)((Object)QueryIds.ALL_USERS), (Object)this.executeAllUsers(EXAMPLE));
    }

    @Override
    public Set<QueryIds> queryIds() {
        return ImmutableSet.of((Object)((Object)QueryIds.NESTED_GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS), (Object)((Object)QueryIds.GROUPS_PER_USER), (Object)((Object)QueryIds.GROUP), (Object)((Object)QueryIds.ALL_USERS));
    }

    public ListResult executeNestedMembership(MembershipCounts membershipCounts) {
        List<Tuple> filtered35K = membershipCounts.getGroups().getTopIds(pair -> (Long)pair.getValue() >= 35000L).stream().map(this::buildMembershipTuple).collect(Collectors.toList());
        if (filtered35K.isEmpty()) {
            List<Tuple> top100 = membershipCounts.getGroups().getTopIds(100).stream().map(this::buildMembershipTuple).collect(Collectors.toList());
            return new ListResult(top100);
        }
        return new ListResult(filtered35K);
    }

    private QueryResult executeNestedGroupsPerUser(MembershipCounts membershipCounts) {
        List<Tuple> top100 = membershipCounts.getUsers().getTopIds(100).stream().map(this::buildGroupTuple).collect(Collectors.toList());
        return new ListResult(top100);
    }

    private QueryResult executeNestedGroup(MembershipCounts membershipCounts) {
        return new LongResult(Long.valueOf(membershipCounts.getGroups().getIds().length));
    }

    private QueryResult executeAllUsers(MembershipCounts membershipCounts) {
        return new LongResult(Long.valueOf(membershipCounts.getUsers().getIds().length));
    }

    private Tuple buildMembershipTuple(Pair<Long, Long> membership) {
        return GuardrailsUtil.getTuple(new GuardrailsTupleElement<Long>(GROUP_ID, (Long)membership.getKey(), Long.class), new GuardrailsTupleElement<Long>(MEMBERSHIP_COUNT, (Long)membership.getValue(), Long.class));
    }

    private Tuple buildGroupTuple(Pair<Long, Long> membership) {
        return GuardrailsUtil.getTuple(new GuardrailsTupleElement<Long>(NUMBER_OF_GROUPS, (Long)membership.getValue(), Long.class), new GuardrailsTupleElement<Long>(USER_ID, (Long)membership.getKey(), Long.class));
    }
}

