/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration;

import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationDarkFeaturesManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationDarkFeaturesManager.class);
    public static final String PLUGIN_FLAG_PREFIX = "migration-assistant.";
    public static final String HANDLE_INVALID_DUPLICATE_EMAIL_USERS = "migration-assistant.handle-invalid-duplicate-email-users";
    public static final String APP_MIGRATION_DEV_MODE = "migration-assistant.app-migration.dev-mode";
    public static final String DISABLE_MISSING_ATTACHMENTS_CHECK = "migration-assistant.disable.missing-attachments-check";
    public static final String DISABLE_APP_OUTDATED_CHECK = "migration-assistant.disable.app-outdated-check";
    public static final String DISABLE_TASK_LIST_FEATURE = "migration-assistant.disable.task-list.feature";
    public static final String ENABLE_EXPORT_ONLY = "migration-assistant.enable.export-only";
    public static final String ENABLE_UPLOAD_ONLY = "migration-assistant.enable.upload-only";
    public static final String SKIP_ATTACHMENTS_UPLOAD = "migration-assistant.skip.attachments.upload";
    public static final String DISABLE_APP_VENDOR_CHECK = "migration-assistant.disable.app-vendor-check";
    public static final String ENABLE_APP_VENDOR_CHECK_FILTER = "enable.app-vendor-check-filter";
    public static final String ENABLE_BROWSER_METRICS = "migration-assistant.enable.assess-l1-cloud-tooling.feature";
    public static final String QUICK_ASSESSMENT = "migration-assistant.assess.quick";
    public static final String DISABLE_CHECKS_BEFORE_RUN = "migration-assistant.disable.checks-before-run";
    public static final String ENABLE_SPACE_USERS_MIGRATIONS_STEP = "migration-assistant.enable.space-users-migration-step";
    public static final String DISABLE_LICENCE_CHECK = "migration-assistant.disable.licence-check";
    public static final String DISABLE_NEW_SPACE_SELECTOR = "migration-assistant.disable.new-space-selector-feature";
    public static final String ENABLE_FED_RAMP = "migration-assistant.enable.fedRAMP";
    public static final String ENABLE_FORCE_RESET_FLAG = "migration-assistant.enable.force-reset-flag";
    public static final String ENABLE_TOKEN_ENCRYPTION = "migration-assistant.enable.token.encryption";
    public static final String DISABLE_TEAM_CALENDARS_MIGRATION = "migration-assistant.disable.team-calendars-migration";
    public static final String ENABLE_RELATIONS_ANALYSIS = "migration-assistant.enable.relations.analysis";
    public static final String ENABLE_RELATIONS_ANALYSIS_DURING_INSTANCE_ASSESSMENT = "migration-assistant.enable.relations.analysis.during.instance.assessment";
    public static final String DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS = "migration-assistant.disable.relations.analysis.user-group-keys";
    public static final String DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS_HASHING = "migration-assistant.disable.relations.analysis.user-group-keys.hashing";
    public static final String ENABLE_FORGE_MIGRATION_PATH = "migration-assistant.enable.forge.migration.path";
    public static final String ENABLE_PARALLEL_APP_DATA_UPLOADS = "migration-assistant.enable.parallel.app.data.uploads";
    public static final String ENABLE_CLOUD_FIRST_MIGRATION = "migration-assistant.enable.cloud.first.migration";
    public static final String DISABLE_SCOPED_GROUPS_MIGRATION = "migration-assistant.macquarie.viper.disable.scoped.groups.migration";
    public static final String ENABLE_APP_DATA_UPLOAD_CACHE = "migration-assistant.cached.app.upload";
    public static final String ENABLE_NEW_ASSESSMENT_STATUS = "migration-assistant.new.assessment.status";
    public static final String ENABLE_PORTFOLIO_ANALYSIS_UI = "migration-assistant.enable.relations.analysis.during.instance.assessment.ui";
    public static final String ENABLE_BATCH_APP_DATA_REQUESTS_TO_APP_AGGREGATOR_SERVICE = "migration-assistant.batch.app.data.requests.to.app.aggregator.service";
    public static final String ENABLE_USER_CSV_MERGE = "migration-assistant.enable.user.csv.merge";
    public static final String ENABLE_MD5_PART_UPLOAD = "migration-assistant.enable.md5.part.upload";
    public static final String DISABLE_READING_SPACE_UPLOAD_FILE_CONFIG_FROM_DB = "migration-assistant.disable.reading.space.upload.file.config.from.db";
    public static final String ENABLE_BROKEN_SEQUENCE_FILTER = "migration-assistant.enable.broken.sequence.filter";
    private boolean spaceUsersMigrationEnabled;
    public static final String MIGRATION_ASSISTANT_DISABLE_GLOBAL_EMAIL_FIXES_FEATURE = "migration-assistant.disable.global.email.fixes.feature";
    public static final String MIGRATION_ASSISTANT_ENABLE_NEW_EMAILS_FROM_DB = "migration-assistant.global.email.fixes.new-email-from-db.feature";
    public static final String MIGRATION_ASSISTANT_DISABLE_UMS_CHECK_FOR_TRUSTED_DOMAINS = "migration-assistant.disable.ums.blocked.domain.preflight.check";
    public static final String MIGRATION_ASSISTANT_ENABLE_EXTENDED_UMS_TIMEOUT = "migration-assistant.enable.extended.ums.timeout";
    private final DarkFeatureManager darkFeatureManager;
    private final FeatureFlagClient featureFlagClient;

    public MigrationDarkFeaturesManager(DarkFeatureManager darkFeatureManager, FeatureFlagClient featureFlagClient) {
        this.darkFeatureManager = darkFeatureManager;
        this.featureFlagClient = featureFlagClient;
    }

    private boolean isFeatureEnabled(String key) {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(key);
    }

    public Set<String> getAllEnabledFeatures() {
        HashSet<String> enabledOnFeatureFlagService = new HashSet<String>(this.featureFlagClient.getAllEnabledFeatureFlags());
        EnabledDarkFeatures featuresEnabledForAllUsers = this.darkFeatureManager.getFeaturesEnabledForAllUsers();
        Set<Object> enabledOnServer = new HashSet();
        try {
            Method getFeatureKeySetMethod = featuresEnabledForAllUsers.getClass().getMethod("getFeatureKeySet", new Class[0]);
            Set featureKeySet = (Set)getFeatureKeySetMethod.invoke((Object)featuresEnabledForAllUsers, new Object[0]);
            enabledOnServer = featureKeySet.stream().filter(featureKey -> featureKey.startsWith(PLUGIN_FLAG_PREFIX)).collect(Collectors.toSet());
        }
        catch (NoSuchMethodException e) {
            try {
                Method getFeatureKeysMethod = featuresEnabledForAllUsers.getClass().getMethod("getFeatureKeys", new Class[0]);
                Set featureKeySet = (Set)getFeatureKeysMethod.invoke((Object)featuresEnabledForAllUsers, new Object[0]);
                enabledOnServer = featureKeySet.stream().filter(featureKey -> featureKey.startsWith(PLUGIN_FLAG_PREFIX)).collect(Collectors.toSet());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException innerException) {
                log.error("Error getting enabled features from confluenceServer", (Throwable)innerException);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Error getting enabled features from confluenceServer", (Throwable)e);
        }
        HashSet<String> result = new HashSet<String>();
        result.addAll(enabledOnFeatureFlagService);
        result.addAll(enabledOnServer);
        if (this.spaceUsersMigrationEnabled) {
            result.add(ENABLE_SPACE_USERS_MIGRATIONS_STEP);
        } else {
            result.remove(ENABLE_SPACE_USERS_MIGRATIONS_STEP);
        }
        return result;
    }

    public boolean appMigrationDevMode() {
        return this.isFeatureEnabled(APP_MIGRATION_DEV_MODE);
    }

    public boolean isBrowserMetricsEnabled() {
        return this.isFeatureEnabled(ENABLE_BROWSER_METRICS);
    }

    public boolean isQuickAssessmentEnabled() {
        return this.isFeatureEnabled(QUICK_ASSESSMENT);
    }

    public boolean missingAttachmentsCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_MISSING_ATTACHMENTS_CHECK);
    }

    public boolean appOutdatedCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_APP_OUTDATED_CHECK);
    }

    public boolean skipAttachmentUploadEnabled() {
        return this.isFeatureEnabled(SKIP_ATTACHMENTS_UPLOAD);
    }

    public boolean shouldHandleInvalidAndDuplicateEmailUsers() {
        return this.isFeatureEnabled(HANDLE_INVALID_DUPLICATE_EMAIL_USERS);
    }

    public boolean shouldHandleGlobalEmailFixes() {
        return this.isGlobalEmailFixesFeatureEnabled();
    }

    boolean isGlobalEmailFixesFeatureEnabled() {
        return !this.isFeatureEnabled(MIGRATION_ASSISTANT_DISABLE_GLOBAL_EMAIL_FIXES_FEATURE);
    }

    public boolean isGlobalEmailFixesNewEmailsFromDbEnabled() {
        return this.isFeatureEnabled(MIGRATION_ASSISTANT_ENABLE_NEW_EMAILS_FROM_DB);
    }

    public boolean isUmsCheckForTrustedDomainsDisabled() {
        return this.isFeatureEnabled(MIGRATION_ASSISTANT_DISABLE_UMS_CHECK_FOR_TRUSTED_DOMAINS);
    }

    public boolean isExtendedUmsTimeoutEnabled() {
        return this.isFeatureEnabled(MIGRATION_ASSISTANT_ENABLE_EXTENDED_UMS_TIMEOUT);
    }

    public boolean isExportOnlyEnabled() {
        return this.isFeatureEnabled(ENABLE_EXPORT_ONLY);
    }

    public boolean isTasklistFeatureDisabled() {
        return this.isFeatureEnabled(DISABLE_TASK_LIST_FEATURE);
    }

    public boolean appVendorCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_APP_VENDOR_CHECK);
    }

    public boolean appVendorChecksFilterEnabled() {
        return this.isFeatureEnabled(ENABLE_APP_VENDOR_CHECK_FILTER);
    }

    public boolean isUploadOnlyEnabled() {
        return this.isFeatureEnabled(ENABLE_UPLOAD_ONLY);
    }

    public boolean isPreflightChecksDisabledBeforeRun() {
        return this.isFeatureEnabled(DISABLE_CHECKS_BEFORE_RUN);
    }

    public boolean isSpaceUsersMigrationStepEnabled() {
        return this.spaceUsersMigrationEnabled;
    }

    public boolean isLicenceCheckDisabled() {
        return this.isFeatureEnabled(DISABLE_LICENCE_CHECK);
    }

    public boolean isNewSpaceSelectorEnabled() {
        return !this.isFeatureEnabled(DISABLE_NEW_SPACE_SELECTOR);
    }

    public void refreshFeatureFlags() {
        this.spaceUsersMigrationEnabled = this.isFeatureEnabled(ENABLE_SPACE_USERS_MIGRATIONS_STEP) || this.featureFlagClient.isFeatureEnabled(ENABLE_SPACE_USERS_MIGRATIONS_STEP);
    }

    public boolean fedRAMPEnabled() {
        return this.isFeatureEnabled(ENABLE_FED_RAMP);
    }

    public boolean isForceResetFlagEnabled() {
        return this.isFeatureEnabled(ENABLE_FORCE_RESET_FLAG);
    }

    public boolean isTokenEncryptionEnabled() {
        return this.isFeatureEnabled(ENABLE_TOKEN_ENCRYPTION);
    }

    public boolean isTeamCalendarsMigrationDisabled() {
        return this.isFeatureEnabled(DISABLE_TEAM_CALENDARS_MIGRATION) || this.featureFlagClient.isFeatureEnabled(DISABLE_TEAM_CALENDARS_MIGRATION);
    }

    public boolean isRelationsAnalysisEnabled() {
        return this.isFeatureEnabled(ENABLE_RELATIONS_ANALYSIS);
    }

    public boolean isRelationsAnalysisDuringInstanceAssessmentEnabled() {
        return this.isFeatureEnabled(ENABLE_RELATIONS_ANALYSIS_DURING_INSTANCE_ASSESSMENT);
    }

    public boolean isRelationsAnalysisUserGroupKeysDisabled() {
        return this.isFeatureEnabled(DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS);
    }

    public boolean isRelationsAnalysisUserGroupKeysHashingDisabled() {
        return this.isFeatureEnabled(DISABLE_RELATIONS_ANALYSIS_USER_GROUP_KEYS_HASHING);
    }

    public boolean isParallelAppDataUploadsEnabled() {
        return this.featureFlagClient.isFeatureEnabled(ENABLE_PARALLEL_APP_DATA_UPLOADS);
    }

    public boolean isForgeMigrationPathEnabled() {
        return this.featureFlagClient.isFeatureEnabled(ENABLE_FORGE_MIGRATION_PATH);
    }

    public boolean isCloudFirstMigrationEnabled() {
        return this.isFeatureEnabled(ENABLE_CLOUD_FIRST_MIGRATION) || this.featureFlagClient.isFeatureEnabled(ENABLE_CLOUD_FIRST_MIGRATION);
    }

    public Boolean isAppDataUploadCacheEnabled() {
        return this.featureFlagClient.isFeatureEnabled(ENABLE_APP_DATA_UPLOAD_CACHE);
    }

    public boolean disableScopedGroupMigration() {
        return this.isFeatureEnabled(DISABLE_SCOPED_GROUPS_MIGRATION) || this.featureFlagClient.isFeatureEnabled(DISABLE_SCOPED_GROUPS_MIGRATION);
    }

    public boolean isNewAssessmentStatusDisabled() {
        return !this.isFeatureEnabled(ENABLE_NEW_ASSESSMENT_STATUS) && !this.isFeatureEnabled(ENABLE_BROWSER_METRICS);
    }

    public boolean isPortfolioAnalysisUiEnabled() {
        return this.isFeatureEnabled(ENABLE_PORTFOLIO_ANALYSIS_UI);
    }

    public boolean isBatchAppDataRequestsToAppAggregatorServiceEnabled() {
        return this.featureFlagClient.isFeatureEnabled(ENABLE_BATCH_APP_DATA_REQUESTS_TO_APP_AGGREGATOR_SERVICE);
    }

    public boolean enableMD5PartUpload() {
        return this.featureFlagClient.isFeatureEnabled(ENABLE_MD5_PART_UPLOAD, true);
    }

    public boolean isReadingSpaceUploadFileConfigFromDBDisabled() {
        return this.featureFlagClient.isFeatureEnabled(DISABLE_READING_SPACE_UPLOAD_FILE_CONFIG_FROM_DB) || this.isFeatureEnabled(DISABLE_READING_SPACE_UPLOAD_FILE_CONFIG_FROM_DB);
    }

    public boolean isUserCsvMergeEnabled() {
        return this.featureFlagClient.isFeatureEnabled(ENABLE_USER_CSV_MERGE) || this.isFeatureEnabled(ENABLE_USER_CSV_MERGE);
    }

    public boolean enableBrokenSequenceFilter() {
        return this.isFeatureEnabled(ENABLE_BROKEN_SEQUENCE_FILTER);
    }
}

